/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.domain;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tohu.domain.DomainModelAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberDomainModelAdapter
implements DomainModelAdapter {
    private static final Logger logger = LoggerFactory.getLogger(NumberDomainModelAdapter.class);

    @Override
    public Set<Class<?>> getSupportedClasses() {
        return new HashSet(Arrays.asList(Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Byte.class, Short.class, Integer.class, Long.class, BigInteger.class));
    }

    @Override
    public String getAnswerType() {
        return "number";
    }

    @Override
    public Object answerToObject(Object answer, Class<?> clazz) {
        logger.debug("Answer to Object is: " + answer);
        if (answer == null) {
            if (clazz.isPrimitive()) {
                answer = 0;
            } else {
                return null;
            }
        }
        if (clazz.isPrimitive()) {
            if (clazz.equals(Byte.TYPE)) {
                clazz = Byte.class;
            } else if (clazz.equals(Short.TYPE)) {
                clazz = Short.class;
            } else if (clazz.equals(Integer.TYPE)) {
                clazz = Integer.class;
            } else if (clazz.equals(Long.TYPE)) {
                clazz = Long.class;
            }
        }
        try {
            return clazz.getConstructor(String.class).newInstance(answer.toString());
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public Object objectToAnswer(Object object) {
        return new Long(object.toString());
    }
}

