/*
 * Decompiled with CFR 0.152.
 */
package org.tohu.domain;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.tohu.domain.DomainModelAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecimalDomainModelAdapter
implements DomainModelAdapter {
    @Override
    public Set<Class<?>> getSupportedClasses() {
        return new HashSet(Arrays.asList(Float.TYPE, Double.TYPE, Float.class, Double.class, BigDecimal.class));
    }

    @Override
    public String getAnswerType() {
        return "decimal";
    }

    @Override
    public Object answerToObject(Object answer, Class<?> clazz) {
        if (answer == null) {
            if (clazz.isPrimitive()) {
                answer = 0;
            } else {
                return null;
            }
        }
        if (clazz.isPrimitive()) {
            if (clazz.equals(Float.TYPE)) {
                clazz = Float.class;
            } else if (clazz.equals(Double.TYPE)) {
                clazz = Double.class;
            }
        }
        try {
            return clazz.getConstructor(String.class).newInstance(answer.toString());
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public Object objectToAnswer(Object object) {
        return new BigDecimal(object.toString());
    }
}

