/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.boot.autoconfigure;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.togglz.core.repository.property.PropertySource;

public class PropertiesPropertySource
implements PropertySource {
    private Properties values = new Properties();

    public PropertiesPropertySource(Properties properties) {
        this.values = properties;
    }

    public void reloadIfUpdated() {
    }

    public Set<String> getKeysStartingWith(String prefix) {
        HashSet<String> result = new HashSet<String>();
        Enumeration<?> keys = this.values.propertyNames();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (!key.startsWith(prefix)) continue;
            result.add(key);
        }
        return result;
    }

    public String getValue(String key, String defaultValue) {
        return this.values.getProperty(key, defaultValue);
    }

    public PropertySource.Editor getEditor() {
        return new PropertiesEditor(this.values);
    }

    private void setValues(Properties values) {
        this.values = values;
    }

    private class PropertiesEditor
    implements PropertySource.Editor {
        private Properties newValues = new Properties();

        private PropertiesEditor(Properties values) {
            this.newValues.putAll((Map<?, ?>)values);
        }

        public void setValue(String key, String value) {
            if (value != null) {
                this.newValues.setProperty(key, value);
            } else {
                this.newValues.remove(key);
            }
        }

        public void removeKeysStartingWith(String prefix) {
            Iterator<Map.Entry<Object, Object>> iterator = this.newValues.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                if (!entry.getKey().toString().startsWith(prefix)) continue;
                iterator.remove();
            }
        }

        public void commit() {
            PropertiesPropertySource.this.setValues(this.newValues);
        }
    }
}

