/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.shade.jmte.template;

import org.togglz.console.shade.jmte.message.ErrorEntry;
import org.togglz.console.shade.jmte.template.OutputAppender;
import org.togglz.console.shade.jmte.token.Token;

public class ErrorReportingOutputAppender
implements OutputAppender {
    private static final String ERROR_PATTERN = "[!!%s|%s|%s!!]";
    private String prefix = "${";
    private String suffix = "}";

    @Override
    public void append(StringBuilder builder, String text, Token token) {
        String textToAppend;
        Object annotation = token.getAnnotation();
        if (annotation instanceof ErrorEntry) {
            ErrorEntry entry = (ErrorEntry)annotation;
            String message = entry.formattedMessage.formatPlain();
            String expressionText = text == null ? "" : this.prefix + token.getText() + this.suffix;
            textToAppend = String.format(ERROR_PATTERN, entry.errorMessage.key, message, expressionText);
        } else {
            textToAppend = text;
        }
        builder.append(textToAppend);
    }
}

