/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.console.model;

import java.util.ArrayList;
import java.util.List;
import org.togglz.console.model.FeatureModel;
import org.togglz.console.model.ParameterModel;
import org.togglz.core.spi.ActivationStrategy;

public class StrategyModel {
    private final int index;
    private final ActivationStrategy strategy;
    private final FeatureModel featureModel;
    private final List<ParameterModel> parameters = new ArrayList<ParameterModel>();

    public StrategyModel(int index, ActivationStrategy strategy, FeatureModel featureModel) {
        this.index = index;
        this.strategy = strategy;
        this.featureModel = featureModel;
    }

    public String getLabel() {
        return this.strategy.getName();
    }

    public String getId() {
        return this.strategy.getId();
    }

    public ActivationStrategy getStrategy() {
        return this.strategy;
    }

    public boolean isSelected() {
        return this.featureModel.getStrategy() != null && this.featureModel.getStrategy().getId().equals(this.getId());
    }

    public void add(ParameterModel param) {
        this.parameters.add(param);
    }

    public List<ParameterModel> getParameters() {
        return this.parameters;
    }

    public int getStrategyIndex() {
        return this.index;
    }

    public boolean isHasParametersWithValues() {
        for (ParameterModel param : this.parameters) {
            if (!param.isHasValue()) continue;
            return true;
        }
        return false;
    }
}

