/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.test.docker;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.tkit.quarkus.test.docker.DockerComposeService;
import org.tkit.quarkus.test.docker.DockerService;
import org.tkit.quarkus.test.docker.DockerTestEnvironment;

public class DockerComposeTestResource
implements QuarkusTestResourceLifecycleManager {
    protected DockerTestEnvironment environment;

    public Map<String, String> start() {
        this.environment = new DockerTestEnvironment();
        this.environment.start();
        return Collections.emptyMap();
    }

    public void stop() {
        this.environment.stop();
    }

    public void inject(Object testInstance) {
        List<Field> fields = DockerComposeTestResource.getDockerComposeServiceFields(testInstance.getClass());
        for (Field f : fields) {
            f.setAccessible(true);
            try {
                DockerComposeService s = this.environment.getService(f.getAnnotation(DockerService.class).value());
                f.set(testInstance, s);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private static List<Field> getDockerComposeServiceFields(Class<?> clazz) {
        if (clazz == null) {
            return Collections.emptyList();
        }
        ArrayList<Field> result = new ArrayList<Field>(DockerComposeTestResource.getDockerComposeServiceFields(clazz.getSuperclass()));
        result.addAll(Arrays.stream(clazz.getDeclaredFields()).filter(f -> DockerComposeService.class.isAssignableFrom(f.getType())).filter(f -> f.getAnnotation(DockerService.class) != null).filter(f -> !f.getAnnotation(DockerService.class).value().isEmpty()).collect(Collectors.toList()));
        return result;
    }
}

