/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.test.docker;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.tkit.quarkus.test.docker.properties.TestProperty;
import org.tkit.quarkus.test.docker.properties.TestPropertyLoader;

public class ContainerConfig {
    public static final Integer DEFAULT_PRIORITY = 100;
    public String name;
    public List<String> command = new ArrayList<String>();
    public boolean integrationTest = true;
    public boolean unitTest = true;
    public PullPolicy imagePull = PullPolicy.DEFAULT;
    public Duration imagePullDuration;
    public Integer priority = DEFAULT_PRIORITY;
    public String image;
    public String waitLogRegex;
    public int waitLogTimes = 1;
    public boolean log = true;
    public Map<String, String> environments;
    public Map<String, String> volumes;
    public Map<String, String> ports;
    public Variables commonVariables = new Variables("test.property.", "test.env.");
    public Variables unitVariables = new Variables("test.unit.property.", "test.unit.env.");
    public Variables integrationVariables = new Variables("test.integration.property.", "test.integration.env.");
    public boolean fixedPorts = false;

    ContainerConfig(String name, Map<String, Object> data) {
        this.name = name;
        this.load(data);
    }

    public static ContainerConfig createContainerProperties(String name, Map<String, Object> data) {
        return new ContainerConfig(name, data);
    }

    private void load(Map<String, Object> data) {
        this.image = (String)data.get("image");
        this.environments = ContainerConfig.getMap(data, "environment");
        this.volumes = ContainerConfig.getMapFromList(data, "volumes", ":");
        this.ports = ContainerConfig.getMapFromList(data, "ports", ":");
        Object cmd = data.get("command");
        this.command = cmd instanceof String ? Collections.singletonList((String)cmd) : ContainerConfig.getList(data, "command");
        Map<String, String> labels = ContainerConfig.getMapFromList(data, "labels", "=");
        if (!labels.isEmpty()) {
            this.integrationTest = ContainerConfig.getLabelBoolean(labels, "test.integration", true);
            this.unitTest = ContainerConfig.getLabelBoolean(labels, "test.unit", true);
            this.imagePull = PullPolicy.valueOf(labels.getOrDefault("test.image.pull", PullPolicy.DEFAULT.name()));
            if (this.imagePull == PullPolicy.MAX_AGE) {
                this.imagePullDuration = Duration.parse(labels.getOrDefault("test.image.pull.max_age", "PT10"));
            }
            this.waitLogRegex = labels.getOrDefault("test.Wait.forLogMessage.regex", null);
            this.waitLogTimes = ContainerConfig.getLabelInteger(labels, "test.Wait.forLogMessage.times", 1);
            this.log = ContainerConfig.getLabelBoolean(labels, "test.Log", true);
            this.priority = ContainerConfig.getLabelInteger(labels, "test.priority", DEFAULT_PRIORITY);
            this.fixedPorts = ContainerConfig.getLabelBoolean(labels, "test.ports.fixed", false);
        }
        labels.forEach((k, v) -> {
            if (!this.commonVariables.readVariable((String)k, (String)v) && !this.unitVariables.readVariable((String)k, (String)v)) {
                this.integrationVariables.readVariable((String)k, (String)v);
            }
        });
    }

    private static Map<String, String> getMap(Map<String, Object> properties, String key) {
        Object map = properties.get(key);
        if (map instanceof Map) {
            return (Map)map;
        }
        return Collections.emptyMap();
    }

    private static List<String> getList(Map<String, Object> properties, String key) {
        Object list = properties.get(key);
        if (list instanceof List) {
            return (List)list;
        }
        return Collections.emptyList();
    }

    private static Map<String, String> getMapFromList(Map<String, Object> properties, String key, String regex) {
        List<String> list = ContainerConfig.getList(properties, key);
        if (!list.isEmpty()) {
            return list.stream().map(s -> s.split(regex, 2)).collect(Collectors.toMap(a -> a[0], a -> ((String[])a).length > 1 ? a[1] : ""));
        }
        return Collections.emptyMap();
    }

    private static boolean getLabelBoolean(Map<String, String> labels, String name, boolean defaultValue) {
        return Boolean.parseBoolean(labels.getOrDefault(name, Boolean.toString(defaultValue)));
    }

    private static int getLabelInteger(Map<String, String> labels, String name, int defaultValue) {
        return Integer.parseInt(labels.getOrDefault(name, Integer.toString(defaultValue)));
    }

    public static class Variables {
        public String propertyPrefix;
        public List<TestProperty> properties = new ArrayList<TestProperty>();
        public String envPrefix;
        public List<TestProperty> environments = new ArrayList<TestProperty>();

        public Variables(String pf, String ep) {
            this.propertyPrefix = pf;
            this.envPrefix = ep;
        }

        public boolean readVariable(String key, String value) {
            if (key.startsWith(this.propertyPrefix)) {
                String k = key.substring(this.propertyPrefix.length());
                this.properties.add(TestPropertyLoader.createTestProperty(k, value));
                return true;
            }
            if (key.startsWith(this.envPrefix)) {
                String k = key.substring(this.envPrefix.length());
                this.environments.add(TestPropertyLoader.createTestProperty(k, value));
                return true;
            }
            return false;
        }
    }

    public static enum PullPolicy {
        DEFAULT,
        ALWAYS,
        MAX_AGE;

    }
}

