/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.rs.resources;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceManager {
    private static final Logger log = LoggerFactory.getLogger(ResourceManager.class);
    private static final String QUARKUS_DEFAULT_LOCALE = "quarkus.default-locale";
    private static final Locale DEFAULT_LOCALE = new Locale(ConfigProvider.getConfig().getOptionalValue("quarkus.default-locale", String.class).orElse(Locale.ENGLISH.getLanguage()));

    public static String getMessage(Enum<?> key, Locale locale, List<Object> params) {
        String resourceBundleName = key.getClass().getSimpleName();
        ClassLoader classLoader = key.getClass().getClassLoader();
        ResourceBundle bundle = null;
        if (locale != null) {
            bundle = ResourceManager.getBundle(resourceBundleName, locale, classLoader);
        }
        if (bundle == null) {
            locale = DEFAULT_LOCALE;
            bundle = ResourceManager.getBundle(resourceBundleName, locale, classLoader);
        }
        if (bundle == null) {
            return key.name() + params;
        }
        String tr = bundle.getString(key.name());
        if (params == null || params.isEmpty()) {
            return tr;
        }
        MessageFormat msgFormat = new MessageFormat(tr, locale);
        StringBuffer bf = msgFormat.format(params.toArray(), new StringBuffer(), (FieldPosition)null);
        return bf.toString();
    }

    private static ResourceBundle getBundle(String bundleName, Locale locale, ClassLoader loader) {
        try {
            if (loader != null && locale != null) {
                return ResourceBundle.getBundle(bundleName, locale, loader);
            }
            if (locale != null) {
                return ResourceBundle.getBundle(bundleName, locale);
            }
            return ResourceBundle.getBundle(bundleName);
        }
        catch (MissingResourceException e) {
            log.debug("Error loading the bundle {} for the locale {}", (Object)bundleName, (Object)locale);
            return null;
        }
    }
}

