/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.rs.interceptors;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Priority;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.quarkus.rs.interceptors.AccessToken;

@Priority(value=1000)
public class OpenIDConnectInterceptor
implements ClientRequestFilter,
ClientResponseFilter {
    private static final String AUTH_RETRY_FLAG = "AUTH_RETRY_FLAG";
    private final Map<String, String> clientConfiguration;
    private static final String ACCESS_TOKEN_SCOPE = "openid";
    private AtomicReference<TokenState> currentTokenState = new AtomicReference();
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenIDConnectInterceptor.class);

    public OpenIDConnectInterceptor() {
        Config config = ConfigProvider.getConfig();
        this.clientConfiguration = Stream.of("CLIENT_ID", "CLIENT_SECRET", "RHSSO_TOKEN_ENDPOINT").collect(HashMap::new, (map, envVarName) -> map.put(envVarName, config.getOptionalValue(envVarName, String.class).orElse(null)), HashMap::putAll);
    }

    public void filter(ClientRequestContext crc) throws IOException {
        if (crc.getUri().toString().equals(this.clientConfiguration.get("RHSSO_TOKEN_ENDPOINT"))) {
            return;
        }
        if (this.clientConfiguration.containsValue(null)) {
            String error = "OPENID client configuration not valid, missing env variables : [" + this.clientConfiguration.entrySet().stream().filter((? super T e) -> e.getValue() == null).map(e -> (String)e.getKey()).collect(Collectors.joining(",")) + "]";
            LOGGER.error(error + ", aborting request processing");
            crc.abortWith(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)error).build());
            return;
        }
        Client client = ClientBuilder.newClient();
        TokenState tokenState = this.currentTokenState.get();
        if (tokenState == null) {
            tokenState = this.requestInitialTokens(client);
            this.currentTokenState.set(tokenState);
        }
        long tokenIssueDate = tokenState.getIssueDate();
        long tokenTTL = tokenState.getTokenTTL();
        if (System.currentTimeMillis() > tokenIssueDate + tokenTTL * 1000L) {
            tokenState = this.refreshToken(crc.getClient(), tokenState);
            this.currentTokenState.set(tokenState);
        }
        String currentToken = tokenState.getToken();
        crc.getHeaders().putSingle((Object)"Authorization", (Object)("Bearer " + currentToken));
    }

    public void filter(ClientRequestContext requestCtx, ClientResponseContext responseCtx) throws IOException {
        boolean wasTokenSentBefore;
        if (requestCtx.getUri().toString().equals(this.clientConfiguration.get("RHSSO_TOKEN_ENDPOINT"))) {
            return;
        }
        if (requestCtx.getProperty(AUTH_RETRY_FLAG) != null) {
            return;
        }
        if (responseCtx.getStatus() == Response.Status.FORBIDDEN.getStatusCode() && (wasTokenSentBefore = requestCtx.getHeaderString("Authorization").toLowerCase().contains("bearer"))) {
            TokenState state = this.currentTokenState.get();
            requestCtx.setProperty(AUTH_RETRY_FLAG, (Object)true);
            TokenState newTokenState = this.refreshToken(requestCtx.getClient(), state);
            this.currentTokenState.set(newTokenState);
            this.repeatRequestWithAuth(requestCtx, responseCtx, newTokenState.getToken());
        }
    }

    private TokenState requestInitialTokens(Client client) throws UnsupportedEncodingException {
        LOGGER.info("Requesting access token");
        Form form = new Form().param("grant_type", "client_credentials").param("scope", ACCESS_TOKEN_SCOPE);
        TokenState newState = this.requestAccessTokenAndUpdateState(client, form);
        LOGGER.info("Access token granted, ttl: {}, expiration: {}", (Object)newState.getTokenTTL(), (Object)newState.getTokenExpirationDate());
        return newState;
    }

    private TokenState requestAccessTokenAndUpdateState(Client client, Form form) throws UnsupportedEncodingException {
        WebTarget target = client.target(this.clientConfiguration.get("RHSSO_TOKEN_ENDPOINT"));
        Map response = (Map)target.request().header("Authorization", (Object)this.getClientCredentialsAuth(this.clientConfiguration.get("CLIENT_ID"), this.clientConfiguration.get("CLIENT_SECRET"))).post(Entity.form((Form)form), (GenericType)new GenericType<Map<String, Object>>(){});
        AccessToken token = this.parseAccessToken(response);
        return this.updateClientTokenState(token);
    }

    private AccessToken parseAccessToken(Map<String, Object> data) {
        AccessToken token = new AccessToken();
        Long longValue = this.getLongValue(data.get("expires_in"));
        if (longValue != null) {
            token.setExpiresIn(longValue);
        }
        if ((longValue = this.getLongValue(data.get("refresh_expires_in"))) != null) {
            token.setRefreshExpiresIn(longValue);
        }
        token.setToken((String)data.get("access_token"));
        token.setRefreshToken((String)data.get("refresh_token"));
        return token;
    }

    private Long getLongValue(Object value) {
        if (value != null) {
            if (value instanceof Integer) {
                return (long)((Integer)value);
            }
            if (value instanceof Long) {
                return (long)((Long)value);
            }
        }
        return null;
    }

    private TokenState refreshToken(Client client, TokenState state) throws UnsupportedEncodingException {
        LOGGER.info("Refreshing access token, refresh expiration: {}", (Object)state.getRefreshTokenExpirationDate());
        Form form = new Form().param("grant_type", "refresh_token").param("scope", ACCESS_TOKEN_SCOPE).param("refresh_token", state.getRefreshToken());
        try {
            TokenState newState = this.requestAccessTokenAndUpdateState(client, form);
            LOGGER.info("Access token refreshed successfully, ttl: {}", (Object)newState.getTokenTTL());
            return newState;
        }
        catch (Exception e) {
            LOGGER.warn("Refresh token request failed, trying to request initial token", (Throwable)e);
            return this.requestInitialTokens(client);
        }
    }

    private boolean repeatRequestWithAuth(ClientRequestContext request, ClientResponseContext response, String token) {
        Client client = request.getClient();
        String method = request.getMethod();
        MediaType mediaType = request.getMediaType();
        URI lUri = request.getUri();
        WebTarget resourceTarget = client.target(lUri);
        Invocation.Builder builder = resourceTarget.request(new MediaType[]{mediaType});
        MultivaluedHashMap newHeaders = new MultivaluedHashMap();
        for (Map.Entry entry : request.getHeaders().entrySet()) {
            if ("Authorization".equals(entry.getKey())) continue;
            newHeaders.put((Object)((String)entry.getKey()), (Object)((List)entry.getValue()));
        }
        newHeaders.add((Object)"Authorization", (Object)("Bearer " + token));
        builder.headers((MultivaluedMap)newHeaders);
        builder.property(AUTH_RETRY_FLAG, (Object)true);
        Invocation invocation = request.getEntity() == null ? builder.build(method) : builder.build(method, Entity.entity((Object)request.getEntity(), (MediaType)request.getMediaType()));
        Response nextResponse = invocation.invoke();
        if (nextResponse.hasEntity()) {
            response.setEntityStream((InputStream)nextResponse.readEntity(InputStream.class));
        }
        MultivaluedMap headers = response.getHeaders();
        headers.clear();
        headers.putAll((Map)nextResponse.getStringHeaders());
        response.setStatus(nextResponse.getStatus());
        return response.getStatus() != Response.Status.UNAUTHORIZED.getStatusCode();
    }

    private TokenState updateClientTokenState(AccessToken tokenResp) {
        TokenState state = new TokenState();
        state.setIssueDate(System.currentTimeMillis());
        if (tokenResp.getRefreshToken() != null) {
            state.setRefreshToken(tokenResp.getRefreshToken());
        }
        state.setTokenTTL(tokenResp.getExpiresIn());
        state.setToken(tokenResp.getToken());
        return state;
    }

    private String getClientCredentialsAuth(String clientId, String clientPassword) throws UnsupportedEncodingException {
        String tmp = clientId + ":" + clientPassword;
        return "Basic " + Base64.getEncoder().encodeToString(tmp.getBytes(StandardCharsets.UTF_8));
    }

    public class TokenState {
        private String token;
        private long issueDate;
        private long tokenTTL;
        private long refreshTokenTTL;
        private String refreshToken;
        private String tokenType;

        public Date getTokenExpirationDate() {
            return new Date(this.issueDate + this.tokenTTL * 1000L);
        }

        public Date getRefreshTokenExpirationDate() {
            return new Date(this.issueDate + this.refreshTokenTTL * 1000L);
        }

        public String getToken() {
            return this.token;
        }

        public long getIssueDate() {
            return this.issueDate;
        }

        public long getTokenTTL() {
            return this.tokenTTL;
        }

        public long getRefreshTokenTTL() {
            return this.refreshTokenTTL;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setIssueDate(long issueDate) {
            this.issueDate = issueDate;
        }

        public void setTokenTTL(long tokenTTL) {
            this.tokenTTL = tokenTTL;
        }

        public void setRefreshTokenTTL(long refreshTokenTTL) {
            this.refreshTokenTTL = refreshTokenTTL;
        }

        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public void setTokenType(String tokenType) {
            this.tokenType = tokenType;
        }
    }
}

