/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.log.rs;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.quarkus.log.cdi.LogService;
import org.tkit.quarkus.log.cdi.interceptor.InterceptorContext;
import org.tkit.quarkus.log.cdi.interceptor.LogConfig;
import org.tkit.quarkus.log.cdi.interceptor.LogServiceInterceptor;
import org.tkit.quarkus.log.rs.RestConfig;

@Provider
@LogService(log=false)
public class RestLogInterceptor
implements ContainerRequestFilter,
ContainerResponseFilter {
    private static final String ANO = "ano";
    private static final String CONTEXT = "context";
    private static final MessageFormat messageStart;
    private static final MessageFormat messageSucceed;
    private static final boolean mdcLog;
    private static final boolean disable;
    private static final boolean disableProtectedMethod;
    private static final Map<String, String> headersLog;
    @Context
    ResourceInfo resourceInfo;
    @Context
    HttpHeaders headers;

    public void filter(ContainerRequestContext requestContext) {
        if (disable) {
            return;
        }
        LogService ano = LogServiceInterceptor.getLoggerServiceAno((Class)this.resourceInfo.getResourceClass(), (String)this.resourceInfo.getResourceClass().getName(), (Method)this.resourceInfo.getResourceMethod(), (boolean)disableProtectedMethod);
        requestContext.setProperty(ANO, (Object)ano);
        for (Map.Entry<String, String> e : headersLog.entrySet()) {
            String tmp = requestContext.getHeaderString(e.getKey());
            if (tmp == null || tmp.isBlank()) continue;
            MDC.put((String)e.getValue(), (Object)tmp);
        }
        if (ano.log()) {
            InterceptorContext context = new InterceptorContext(requestContext.getMethod(), requestContext.getUriInfo().getRequestUri().toString());
            requestContext.setProperty(CONTEXT, (Object)context);
            if (mdcLog) {
                MDC.put((String)"rs-method", (Object)context.method);
                MDC.put((String)"rs-uri", (Object)context.parameters);
            }
            Logger logger = LoggerFactory.getLogger((Class)this.resourceInfo.getResourceClass());
            boolean hasEntity = requestContext.getMediaType() != null && requestContext.getLength() > 0;
            logger.info("{}", LogConfig.msg((MessageFormat)messageStart, (Object[])new Object[]{context.method, requestContext.getUriInfo().getRequestUri(), hasEntity}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        if (disable) {
            return;
        }
        LogService ano = (LogService)requestContext.getProperty(ANO);
        if (ano != null && ano.log()) {
            try {
                InterceptorContext context = (InterceptorContext)requestContext.getProperty(CONTEXT);
                Response.StatusType status = responseContext.getStatusInfo();
                context.closeContext(status.getReasonPhrase());
                if (mdcLog) {
                    MDC.put((String)"rs-method", (Object)context.method);
                    MDC.put((String)"rs-uri", (Object)context.parameters);
                    MDC.put((String)"rs-time", (Object)context.time);
                    MDC.put((String)"rs-response-status", (Object)status.getStatusCode());
                    MDC.put((String)"rs-response-reason", (Object)status.getReasonPhrase());
                    MDC.put((String)"rs-response-entity", (Object)responseContext.hasEntity());
                }
                Logger logger = LoggerFactory.getLogger((Class)this.resourceInfo.getResourceClass());
                logger.info("{}", LogConfig.msg((MessageFormat)messageSucceed, (Object[])new Object[]{context.method, context.parameters, context.time, status.getStatusCode(), status.getReasonPhrase(), responseContext.hasEntity()}));
            }
            catch (Throwable throwable) {
                for (String e : headersLog.keySet()) {
                    MDC.remove((String)e);
                }
                if (mdcLog) {
                    MDC.remove((String)"rs-method");
                    MDC.remove((String)"rs-uri");
                    MDC.remove((String)"rs-entity");
                    MDC.remove((String)"rs-time");
                    MDC.remove((String)"rs-response-status");
                    MDC.remove((String)"rs-response-reason");
                    MDC.remove((String)"rs-response-entity");
                    Optional prefixToClear = ConfigProvider.getConfig().getOptionalValue("quarkus.tkit.log.customdata.prefix", String.class);
                    prefixToClear.ifPresent(value -> MDC.getMap().keySet().stream().filter((? super T s) -> s.startsWith((String)value)).forEach(MDC::remove));
                }
                throw throwable;
            }
            for (String e : headersLog.keySet()) {
                MDC.remove((String)e);
            }
            if (mdcLog) {
                MDC.remove((String)"rs-method");
                MDC.remove((String)"rs-uri");
                MDC.remove((String)"rs-entity");
                MDC.remove((String)"rs-time");
                MDC.remove((String)"rs-response-status");
                MDC.remove((String)"rs-response-reason");
                MDC.remove((String)"rs-response-entity");
                Optional prefixToClear = ConfigProvider.getConfig().getOptionalValue("quarkus.tkit.log.customdata.prefix", String.class);
                prefixToClear.ifPresent(value -> MDC.getMap().keySet().stream().filter((? super T s) -> s.startsWith((String)value)).forEach(MDC::remove));
            }
        }
    }

    static {
        headersLog = new HashMap<String, String>();
        Config config = ConfigProvider.getConfig();
        messageStart = new MessageFormat(config.getOptionalValue("tkit.log.rs.start", String.class).orElse("{0} {1} [{2}] started."));
        messageSucceed = new MessageFormat(config.getOptionalValue("tkit.log.rs.succeed", String.class).orElse("{0} {1} [{2}s] finished [{3}-{4},{5}]."));
        disable = config.getOptionalValue("tkit.log.rs.disable", Boolean.class).orElse(false);
        mdcLog = config.getOptionalValue("tkit.log.rs.mdc", Boolean.class).orElse(false);
        disableProtectedMethod = config.getOptionalValue("tkit.log.method.protected.disable", Boolean.class).orElse(true);
        String[] items = config.getOptionalValue("tkit.log.rs.header", String[].class).orElse(null);
        headersLog.putAll(RestConfig.convert(items));
    }
}

