/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.log.rs;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.quarkus.log.cdi.LogService;
import org.tkit.quarkus.log.cdi.interceptor.InterceptorContext;
import org.tkit.quarkus.log.cdi.interceptor.LogConfig;
import org.tkit.quarkus.log.rs.RestConfig;

@Provider
@LogService(log=false)
public class RestClientLogInterceptor
implements ClientRequestFilter,
ClientResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(RestClientLogInterceptor.class);
    private static final String CONTEXT = "context";
    private static final MessageFormat messageStart;
    private static final MessageFormat messageSucceed;
    private static final boolean disable;
    private static final boolean mdcLog;
    private static final Map<String, String> headersLog;

    public void filter(ClientRequestContext requestContext) {
        if (disable) {
            return;
        }
        InterceptorContext context = new InterceptorContext(requestContext.getMethod(), requestContext.getUri().toString());
        for (Map.Entry<String, String> e : headersLog.entrySet()) {
            String tmp = requestContext.getHeaderString(e.getKey());
            if (tmp == null || tmp.isBlank()) continue;
            MDC.put((String)e.getValue(), (Object)tmp);
        }
        if (mdcLog) {
            MDC.put((String)"rs-client-method", (Object)context.method);
            MDC.put((String)"rs-client-uri", (Object)context.parameters);
        }
        requestContext.setProperty(CONTEXT, (Object)context);
        log.info("{}", LogConfig.msg((MessageFormat)messageStart, (Object[])new Object[]{requestContext.getMethod(), requestContext.getUri(), requestContext.hasEntity()}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) {
        if (disable) {
            return;
        }
        InterceptorContext context = (InterceptorContext)requestContext.getProperty(CONTEXT);
        if (context != null) {
            try {
                Response.StatusType status = responseContext.getStatusInfo();
                context.closeContext(status.getReasonPhrase());
                if (mdcLog) {
                    MDC.put((String)"rs-client-method", (Object)context.method);
                    MDC.put((String)"rs-client-uri", (Object)context.parameters);
                    MDC.put((String)"rs-client-time", (Object)context.time);
                    MDC.put((String)"rs-client-response-status", (Object)status.getStatusCode());
                    MDC.put((String)"rs-client-response-phrase", (Object)status.getReasonPhrase());
                    MDC.put((String)"rs-client-response-entity", (Object)responseContext.hasEntity());
                }
                log.info("{}", LogConfig.msg((MessageFormat)messageSucceed, (Object[])new Object[]{context.method, requestContext.getUri(), context.time, status.getStatusCode(), context.result, responseContext.hasEntity()}));
            }
            finally {
                for (String e : headersLog.keySet()) {
                    MDC.remove((String)e);
                }
                if (mdcLog) {
                    MDC.remove((String)"rs-client-method");
                    MDC.remove((String)"rs-client-uri");
                    MDC.remove((String)"rs-client-entity");
                    MDC.remove((String)"rs-client-time");
                    MDC.remove((String)"rs-client-response-status");
                    MDC.remove((String)"rs-client-response-phrase");
                    MDC.remove((String)"rs-client-response-entity");
                }
            }
        }
    }

    static {
        headersLog = new HashMap<String, String>();
        Config config = ConfigProvider.getConfig();
        messageStart = new MessageFormat(config.getOptionalValue("tkit.log.rs.client.start", String.class).orElse("{0} {1} [{2}] started."));
        messageSucceed = new MessageFormat(config.getOptionalValue("tkit.log.rs.client.succeed", String.class).orElse("{0} {1} finished in [{2}s] with [{3}-{4},{5}]."));
        disable = config.getOptionalValue("tkit.log.rs.client.disable", Boolean.class).orElse(false);
        mdcLog = config.getOptionalValue("tkit.log.rs.client.mdc", Boolean.class).orElse(false);
        String[] items = config.getOptionalValue("tkit.log.rs.client.header", String[].class).orElse(null);
        headersLog.putAll(RestConfig.convert(items));
    }
}

