/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.log.cdi.interceptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Proxy;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.MDC;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tkit.quarkus.log.cdi.LogExclude;
import org.tkit.quarkus.log.cdi.LogFriendlyException;
import org.tkit.quarkus.log.cdi.LogService;
import org.tkit.quarkus.log.cdi.interceptor.InterceptorContext;
import org.tkit.quarkus.log.cdi.interceptor.LogConfig;
import org.tkit.quarkus.log.cdi.interceptor.LogParamValueService;

@Interceptor
@LogService
@Priority(value=1002)
public class LogServiceInterceptor {
    public static final String PROP_DISABLE_PROTECTED_METHODS = "tkit.log.method.protected.disable";
    @Inject
    LogParamValueService logParamService;
    @Inject
    @ConfigProperty(name="tkit.log.method.protected.disable", defaultValue="true")
    boolean disableProtectedMethod;
    @Inject
    @ConfigProperty(name="tkit.log.mdc", defaultValue="false")
    boolean mdcLog;
    @Inject
    @ConfigProperty(name="quarkus.tkit.log.mdc.errorKey", defaultValue="errorNumber")
    public String errorNumberKey;

    private static String getObjectClassName(Object object) {
        Class<?>[] interf;
        if (object instanceof Proxy && (interf = object.getClass().getInterfaces()).length > 0) {
            return LogServiceInterceptor.getClassName(interf[0]);
        }
        return LogServiceInterceptor.getClassName(object.getClass());
    }

    private static String getClassName(Class<?> clazz) {
        if (clazz != null && clazz.getSuperclass() != null) {
            return clazz.getSuperclass().getName();
        }
        if (clazz != null) {
            return clazz.getName();
        }
        return null;
    }

    public static LogService getLoggerServiceAno(Class<?> clazz, String className, Method method, boolean disableProtectedMethod) {
        if (disableProtectedMethod && Modifier.isProtected(method.getModifiers())) {
            return LogServiceInterceptor.createLoggerService(false, false);
        }
        Config config = ConfigProvider.getConfig();
        String mc = className + "." + method.getName() + "/tkit-log/";
        String c = className + "/tkit-log/";
        Optional log = config.getOptionalValue(mc + "log", Boolean.class);
        Optional trace = config.getOptionalValue(mc + "trace", Boolean.class);
        LogService anno = method.getAnnotation(LogService.class);
        if (anno != null) {
            return LogServiceInterceptor.createLoggerService(log.orElse(anno.log()), trace.orElse(anno.stacktrace()));
        }
        Optional clog = config.getOptionalValue(c + "log", Boolean.class);
        Optional ctrace = config.getOptionalValue(c + "trace", Boolean.class);
        LogService canno = clazz.getAnnotation(LogService.class);
        if (canno != null) {
            return LogServiceInterceptor.createLoggerService(log.orElse(clog.orElse(canno.log())), trace.orElse(ctrace.orElse(canno.stacktrace())));
        }
        return LogServiceInterceptor.createLoggerService(log.orElse(clog.orElse(true)), trace.orElse(ctrace.orElse(true)));
    }

    private static LogService createLoggerService(final boolean log, final boolean stacktrace) {
        return new LogService(){

            @Override
            public boolean log() {
                return log;
            }

            @Override
            public boolean stacktrace() {
                return stacktrace;
            }

            @Override
            public Class<? extends Annotation> annotationType() {
                return LogService.class;
            }
        };
    }

    @AroundInvoke
    public Object methodExecution(InvocationContext ic) throws Exception {
        Object result;
        Method method = ic.getMethod();
        String className = LogServiceInterceptor.getObjectClassName(ic.getTarget());
        LogService ano = LogServiceInterceptor.getLoggerServiceAno(ic.getTarget().getClass(), className, method, this.disableProtectedMethod);
        if (ano.log()) {
            Logger logger = LoggerFactory.getLogger((String)className);
            String parameters = this.getValuesString(ic.getParameters(), method.getParameters());
            InterceptorContext context = new InterceptorContext(method.getName(), parameters);
            try {
                if (this.mdcLog) {
                    MDC.put((String)"method", (Object)context.method);
                    MDC.put((String)"parameters", (Object)context.parameters);
                    MDC.put((String)"status", (Object)"started");
                }
                logger.info("{}", LogConfig.msgStart(context));
                result = ic.proceed();
                if (result instanceof CompletionStage) {
                    if (this.mdcLog) {
                        MDC.put((String)"method", (Object)context.method);
                        MDC.put((String)"parameters", (Object)context.parameters);
                        MDC.put((String)"status", (Object)"future");
                    }
                    logger.info("{}", LogConfig.msgFutureStart(context));
                    CompletionStage cs = (CompletionStage)result;
                    cs.toCompletableFuture().whenComplete((u, eex) -> {
                        if (eex != null) {
                            this.handleException(context, logger, ano, (Throwable)eex);
                        } else {
                            String contextResult = LogConfig.RESULT_VOID;
                            if (u != Void.TYPE) {
                                contextResult = this.getValue(u);
                            }
                            context.closeContext(contextResult);
                            if (this.mdcLog) {
                                MDC.put((String)"method", (Object)context.method);
                                MDC.put((String)"parameters", (Object)context.parameters);
                                MDC.put((String)"status", (Object)"succeed");
                                MDC.put((String)"result", (Object)context.result);
                                MDC.put((String)"time", (Object)context.time);
                            }
                            logger.info("{}", LogConfig.msgSucceed(context));
                        }
                    });
                }
                String contextResult = LogConfig.RESULT_VOID;
                if (method.getReturnType() != Void.TYPE) {
                    contextResult = this.getValue(result);
                }
                context.closeContext(contextResult);
                if (this.mdcLog) {
                    MDC.put((String)"method", (Object)context.method);
                    MDC.put((String)"parameters", (Object)context.parameters);
                    MDC.put((String)"status", (Object)"succeed");
                    MDC.put((String)"result", (Object)context.result);
                    MDC.put((String)"time", (Object)context.time);
                }
                logger.info("{}", LogConfig.msgSucceed(context));
            }
            catch (InvocationTargetException ie) {
                this.handleException(context, logger, ano, ie.getCause());
                throw ie;
            }
            catch (Exception ex) {
                this.handleException(context, logger, ano, ex);
                throw ex;
            }
            finally {
                if (this.mdcLog) {
                    MDC.remove((String)"method");
                    MDC.remove((String)"parameters");
                    MDC.remove((String)"status");
                    MDC.remove((String)"result");
                    MDC.remove((String)"time");
                    MDC.remove((String)this.errorNumberKey);
                }
            }
        } else {
            result = ic.proceed();
        }
        return result;
    }

    private void handleException(InterceptorContext context, Logger logger, LogService ano, Throwable ex) {
        context.closeContext(this.getValue(ex));
        if (this.mdcLog) {
            MDC.put((String)"method", (Object)context.method);
            MDC.put((String)"parameters", (Object)context.parameters);
            MDC.put((String)"result", (Object)context.result);
            MDC.put((String)"time", (Object)context.time);
            MDC.put((String)"status", (Object)"error");
            if (ex instanceof LogFriendlyException) {
                MDC.put((String)this.errorNumberKey, (Object)((LogFriendlyException)((Object)ex)).getErrorNumber());
            }
        }
        logger.error("{}", LogConfig.msgFailed(context));
        boolean stacktrace = ano.stacktrace();
        if (ex instanceof LogFriendlyException) {
            if (stacktrace && ((LogFriendlyException)((Object)ex)).shouldLogStacktrace()) {
                logger.error("Error ", ex);
            }
        } else if (stacktrace) {
            logger.error("Error ", ex);
        }
    }

    private String getValuesString(Object[] value, Parameter[] parameters) {
        if (value != null && value.length > 0) {
            StringBuilder sb = new StringBuilder();
            int index = 0;
            sb.append(this.getValue(value[index], parameters[index]));
            ++index;
            while (index < value.length) {
                sb.append(',');
                sb.append(this.getValue(value[index], parameters[index]));
                ++index;
            }
            return sb.toString();
        }
        return "";
    }

    private String getValue(Object value, Parameter parameter) {
        LogExclude pa = parameter.getAnnotation(LogExclude.class);
        if (pa != null) {
            if (!pa.mask().isEmpty()) {
                return pa.mask();
            }
            return parameter.getName();
        }
        return this.getValue(value);
    }

    private String getValue(Object parameter) {
        return this.logParamService.getParameterValue(parameter);
    }
}

