/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.jpa.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;

public class QueryCriteriaUtil {
    private QueryCriteriaUtil() {
    }

    public static String wildcard(String searchString) {
        return QueryCriteriaUtil.wildcard(searchString, true);
    }

    public static String wildcard(String searchString, boolean caseInsensitive) {
        String result = searchString;
        if (caseInsensitive) {
            result = result.toLowerCase();
        }
        if (searchString.indexOf(42) != -1) {
            result = result.replace('*', '%');
        }
        if (searchString.indexOf(63) != -1) {
            result = result.replace('?', '_');
        }
        return result;
    }

    public static Predicate inClause(Expression<?> path, Collection<?> values, CriteriaBuilder cb) {
        Predicate result = path.in(values);
        if (values.size() > 1000) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            ArrayList valuesList = new ArrayList(values);
            while (valuesList.size() > 1000) {
                List subList = valuesList.subList(0, 1000);
                predicates.add(path.in(subList));
                subList.clear();
            }
            predicates.add(path.in(valuesList));
            result = cb.or(predicates.toArray(new Predicate[predicates.size()]));
        }
        return result;
    }

    public static Predicate notInClause(Expression<?> path, Collection<?> values, CriteriaBuilder cb) {
        Predicate result = cb.not((Expression)path.in(values));
        if (values.size() > 1000) {
            ArrayList<Predicate> predicates = new ArrayList<Predicate>();
            ArrayList valuesList = new ArrayList(values);
            while (valuesList.size() > 1000) {
                List subList = valuesList.subList(0, 1000);
                predicates.add(cb.not((Expression)path.in(subList)));
                subList.clear();
            }
            predicates.add(cb.not((Expression)path.in(valuesList)));
            result = cb.and(predicates.toArray(new Predicate[predicates.size()]));
        }
        return result;
    }

    public static String inClause(String attribute, String attributeName, Collection<?> values, Map<String, Object> parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(attribute).append(" IN (:").append(attributeName).append(")");
        ArrayList valuesList = new ArrayList(values);
        if (values.size() > 1000) {
            int i = 0;
            while (valuesList.size() > 1000) {
                List subList = valuesList.subList(0, 1000);
                sb.append(" OR ").append(attribute).append(" IN (:").append(attributeName).append(i).append(")");
                parameters.put(attributeName + i, new ArrayList(subList));
                subList.clear();
                ++i;
            }
        }
        sb.append(")");
        parameters.put(attributeName, valuesList);
        return sb.toString();
    }

    public static String notInClause(String attribute, String attributeName, Collection<?> values, Map<String, Object> parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append("(").append(attribute).append(" NOT IN (:").append(attributeName).append(")");
        ArrayList valuesList = new ArrayList(values);
        if (values.size() > 1000) {
            int i = 0;
            while (valuesList.size() > 1000) {
                List subList = valuesList.subList(0, 1000);
                sb.append(" AND ").append(attribute).append(" NOT IN (:").append(attributeName).append(i).append(")");
                parameters.put(attributeName + i, new ArrayList(subList));
                subList.clear();
                ++i;
            }
        }
        sb.append(")");
        parameters.put(attributeName, valuesList);
        return sb.toString();
    }
}

