/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.jpa.exceptions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DAOException
extends RuntimeException {
    public final Enum<?> key;
    public final List<Object> parameters = new ArrayList<Object>();
    public final Map<String, Object> namedParameters = new HashMap<String, Object>();

    public DAOException(Enum<?> key, Throwable cause, Object ... parameters) {
        super(cause);
        this.key = key;
        if (parameters != null && parameters.length > 0) {
            this.parameters.addAll(Arrays.asList(parameters));
        }
    }

    @Override
    public String getMessage() {
        return this.key.getClass().getSimpleName() + ",key:" + this.key.name() + ",parameters:" + this.parameters + ",namedParameters:" + this.namedParameters;
    }

    public Enum<?> getMessageKey() {
        return this.key;
    }

    public final void addParameter(Object parameter) {
        this.parameters.add(parameter);
    }

    public final void addParameter(List<Object> parameters) {
        if (parameters != null) {
            this.parameters.addAll(parameters);
        }
    }

    public final void addParameter(String name, Object parameter) {
        if (name != null) {
            this.namedParameters.put(name, parameter);
        }
    }

    public final void addParameter(Map<String, Object> namedParameters) {
        if (namedParameters != null) {
            this.namedParameters.putAll(namedParameters);
        }
    }

    @Override
    public String toString() {
        return this.key.name();
    }
}

