/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.jpa.daos;

import java.util.stream.Stream;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.tkit.quarkus.jpa.daos.Page;
import org.tkit.quarkus.jpa.daos.PageResult;
import org.tkit.quarkus.jpa.exceptions.DAOException;

public class PagedQuery<T> {
    private EntityManager em;
    private CriteriaQuery<T> criteria;
    private CriteriaQuery<Long> countCriteria;
    private Page page;

    public PagedQuery(EntityManager em, CriteriaQuery<T> criteria, Page page) {
        this.em = em;
        this.criteria = criteria;
        this.page = page;
        this.countCriteria = PagedQuery.createCountCriteria(em, criteria);
    }

    public PageResult<T> getPageResult() {
        try {
            Long count = (Long)this.em.createQuery(this.countCriteria).getSingleResult();
            Stream stream = this.em.createQuery(this.criteria).setFirstResult(this.page.number() * this.page.size()).setMaxResults(this.page.size()).getResultStream();
            return new PageResult(count, stream, this.page);
        }
        catch (Exception ex) {
            String entityClass = this.criteria.getResultType() != null ? this.criteria.getResultType().getName() : null;
            throw new DAOException(Errors.GET_PAGE_RESULT_ERROR, (Throwable)ex, this.page.number(), this.page.size(), entityClass);
        }
    }

    public Page getPage() {
        return this.page;
    }

    public CriteriaQuery<Long> countCriteria() {
        return this.countCriteria;
    }

    public PagedQuery<T> previous() {
        if (this.page.number() > 0) {
            this.page = Page.of(this.page.number() - 1, this.page.size());
        }
        return this;
    }

    public PagedQuery<T> next() {
        this.page = Page.of(this.page.number() + 1, this.page.size());
        return this;
    }

    public static <T> CriteriaQuery<Long> createCountCriteria(EntityManager em, CriteriaQuery<T> criteria) {
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery<Long> countCriteria = PagedQuery.createCountCriteriaQuery(builder, criteria, false);
        Expression countExpression = criteria.isDistinct() ? builder.countDistinct(PagedQuery.findRoot(countCriteria, criteria.getResultType())) : builder.count(PagedQuery.findRoot(countCriteria, criteria.getResultType()));
        return countCriteria.select((Selection)countExpression);
    }

    public static CriteriaQuery<Long> createCountCriteriaQuery(CriteriaBuilder builder, CriteriaQuery<?> from, boolean fetches) {
        Predicate predicate;
        CriteriaQuery result = builder.createQuery(Long.class);
        AliasCounter counter = new AliasCounter();
        from.getRoots().forEach(root -> {
            Root dest = result.from(root.getJavaType());
            dest.alias(PagedQuery.createAlias(root, counter));
            PagedQuery.copyJoins(root, dest, counter);
            if (fetches) {
                PagedQuery.copyFetches(root, dest);
            }
        });
        result.groupBy(from.getGroupList());
        result.distinct(from.isDistinct());
        if (from.getGroupRestriction() != null) {
            result.having((Expression)from.getGroupRestriction());
        }
        if ((predicate = from.getRestriction()) != null) {
            result.where((Expression)predicate);
        }
        return result;
    }

    public static <T> Root<T> findRoot(CriteriaQuery<?> query, Class<T> clazz) {
        for (Root r : query.getRoots()) {
            if (!clazz.equals(r.getJavaType())) continue;
            return (Root)r.as(clazz);
        }
        return null;
    }

    public static void copyJoins(From<?, ?> from, From<?, ?> to, AliasCounter counter) {
        from.getJoins().forEach(join -> {
            Join item = to.join(join.getAttribute().getName(), join.getJoinType());
            item.alias(PagedQuery.createAlias(join, counter));
            PagedQuery.copyJoins(join, item, counter);
        });
    }

    public static void copyFetches(From<?, ?> from, From<?, ?> to) {
        from.getFetches().forEach(fetch -> {
            Fetch item = to.fetch(fetch.getAttribute().getName(), fetch.getJoinType());
            PagedQuery.copyFetches(fetch, item);
        });
    }

    public static void copyFetches(Fetch<?, ?> from, Fetch<?, ?> to) {
        from.getFetches().forEach(fetch -> {
            Fetch item = to.fetch(fetch.getAttribute().getName(), fetch.getJoinType());
            PagedQuery.copyFetches(fetch, item);
        });
    }

    public static <T> String createAlias(Selection<T> selection, AliasCounter counter) {
        String alias = selection.getAlias();
        if (alias == null) {
            alias = counter.next();
            selection.alias(alias);
        }
        return alias;
    }

    public String toString() {
        return "PagedQuery{page=" + this.page + "}";
    }

    public static class AliasCounter {
        private long index = 0L;

        public String next() {
            return "a_" + this.index++;
        }
    }

    public static enum Errors {
        GET_PAGE_RESULT_ERROR;

    }
}

