/*
 * Decompiled with CFR 0.152.
 */
package org.tkit.quarkus.jpa.daos;

import java.util.stream.Stream;
import org.tkit.quarkus.jpa.daos.Page;

public class PageResult<T> {
    private long totalElements;
    private int number;
    private int size;
    private long totalPages;
    private Stream<T> stream;

    public PageResult(long totalElements, Stream<T> stream, Page page) {
        this.totalElements = totalElements;
        this.stream = stream;
        this.number = page.number();
        this.size = page.size();
        this.totalPages = (totalElements + (long)this.size - 1L) / (long)this.size;
    }

    public long getTotalPages() {
        return this.totalPages;
    }

    public long getSize() {
        return this.size;
    }

    public long getNumber() {
        return this.number;
    }

    public long getTotalElements() {
        return this.totalElements;
    }

    public Stream<T> getStream() {
        return this.stream;
    }

    public String toString() {
        return "PageResult{c=" + this.totalElements + ",n=" + this.number + ",s=" + this.size + "}";
    }
}

