/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.tinylog.Level;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.FormatPatternParser;
import org.tinylog.pattern.Token;
import org.tinylog.provider.InternalLogger;
import org.tinylog.writers.Writer;
import org.tinylog.writers.raw.BufferedWriterDecorator;
import org.tinylog.writers.raw.ByteArrayWriter;
import org.tinylog.writers.raw.RandomAccessFileWriter;
import org.tinylog.writers.raw.SynchronizedWriterDecorator;

public final class JsonWriter
implements Writer {
    private static final String NEW_LINE = System.getProperty("line.separator");
    private static final int BUFFER_SIZE = 1024;
    private static final String FIELD_PREFIX = "field.";
    private final Charset charset;
    private final RandomAccessFile randomAccessFile;
    private ByteArrayWriter writer;
    private StringBuilder builder;
    private final Map<String, Token> jsonProperties;
    private final byte[] newLineBytes;
    private final byte[] commaBytes;
    private final byte[] bracketOpenBytes;
    private final byte[] bracketCloseBytes;

    public JsonWriter() throws IOException {
        this(Collections.emptyMap());
    }

    public JsonWriter(Map<String, String> properties) throws IOException {
        boolean writingThread;
        this.jsonProperties = JsonWriter.createTokens(properties);
        this.charset = this.getCharset(properties);
        this.newLineBytes = NEW_LINE.getBytes(this.charset);
        this.commaBytes = ",".getBytes(this.charset);
        this.bracketOpenBytes = "[".getBytes(this.charset);
        this.bracketCloseBytes = "]".getBytes(this.charset);
        String fileName = this.getFileName(properties);
        File file = new File(fileName).getAbsoluteFile();
        file.getParentFile().mkdirs();
        boolean append = Boolean.parseBoolean(properties.get("append"));
        this.randomAccessFile = new RandomAccessFile(file, "rw");
        this.writer = new RandomAccessFileWriter(this.randomAccessFile);
        boolean buffered = Boolean.parseBoolean(properties.get("buffered"));
        if (buffered) {
            this.writer = new BufferedWriterDecorator(this.writer);
        }
        if (writingThread = Boolean.parseBoolean(properties.get("writingthread"))) {
            this.builder = new StringBuilder();
        } else {
            this.writer = new SynchronizedWriterDecorator(this.writer, this.randomAccessFile);
        }
        this.preProcessFile(append);
    }

    @Override
    public void write(LogEntry logEntry) throws IOException {
        StringBuilder builder;
        if (this.builder == null) {
            builder = new StringBuilder();
        } else {
            builder = this.builder;
            builder.setLength(0);
        }
        this.addJsonObject(logEntry, builder);
        this.writer.write(builder.toString().getBytes(this.charset), builder.length());
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.flush();
        this.postProcessFile();
        this.writer.close();
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        EnumSet<LogEntryValue> values = EnumSet.noneOf(LogEntryValue.class);
        for (Token token : this.jsonProperties.values()) {
            values.addAll(token.getRequiredLogEntryValues());
        }
        return values;
    }

    private void addJsonObject(LogEntry logEntry, StringBuilder builder) {
        builder.append(NEW_LINE);
        builder.append('\t');
        builder.append("{").append(NEW_LINE);
        Token[] tokenEntries = this.jsonProperties.values().toArray(new Token[0]);
        String[] fields = this.jsonProperties.keySet().toArray(new String[0]);
        for (int i = 0; i < tokenEntries.length; ++i) {
            builder.append("\t\t\"").append(fields[i]).append("\" : \"");
            int start = builder.length();
            Token token = tokenEntries[i];
            token.render(logEntry, builder);
            this.escapeCharacter("\\", "\\\\", builder, start);
            this.escapeCharacter("\"", "\\\"", builder, start);
            this.escapeCharacter(NEW_LINE, "\\n", builder, start);
            this.escapeCharacter("\t", "\\t", builder, start);
            this.escapeCharacter("\b", "\\b", builder, start);
            this.escapeCharacter("\f", "\\f", builder, start);
            this.escapeCharacter("\n", "\\n", builder, start);
            this.escapeCharacter("\r", "\\r", builder, start);
            builder.append("\" ");
            if (i + 1 >= this.jsonProperties.size()) continue;
            builder.append(",").append(NEW_LINE);
        }
        builder.append(NEW_LINE).append("\t},");
    }

    private void escapeCharacter(String character, String escapeWith, StringBuilder stringBuilder, int startIndex) {
        int index = stringBuilder.indexOf(character, startIndex);
        while (index != -1) {
            stringBuilder.replace(index, index + character.length(), escapeWith);
            index = stringBuilder.indexOf(character, index + escapeWith.length());
        }
    }

    private Charset getCharset(Map<String, String> properties) {
        String charsetName = properties.get("charset");
        try {
            return charsetName == null ? Charset.defaultCharset() : Charset.forName(charsetName);
        }
        catch (IllegalArgumentException ex) {
            InternalLogger.log((Level)Level.ERROR, (String)("Invalid charset: " + charsetName));
            return Charset.defaultCharset();
        }
    }

    private String getFileName(Map<String, String> properties) {
        String fileName = properties.get("file");
        if (fileName == null) {
            throw new IllegalArgumentException("File name is missing for file writer");
        }
        return fileName;
    }

    private boolean isWhitespace(byte character) {
        return character == 10 || character == 13 || character == 32;
    }

    private void preProcessFile(boolean append) throws IOException, IllegalArgumentException {
        if (append && this.randomAccessFile.length() > 0L) {
            long sizeToTruncate = 0L;
            boolean foundClosingBracket = false;
            byte[] bytes = new byte[1024];
            this.randomAccessFile.seek(Math.max(0L, this.randomAccessFile.length() - 1024L));
            int numberOfBytes = this.randomAccessFile.read(bytes);
            for (int i = numberOfBytes - 1; i >= 0; --i) {
                byte letter = bytes[i];
                ++sizeToTruncate;
                if (letter == 93) {
                    foundClosingBracket = true;
                    continue;
                }
                if (!foundClosingBracket || this.isWhitespace(letter)) continue;
                --sizeToTruncate;
                break;
            }
            if (!foundClosingBracket) {
                throw new IllegalArgumentException("Invalid JSON file. The file is missing a closing bracket for the array.");
            }
            long newFileSize = this.randomAccessFile.length() - sizeToTruncate;
            this.randomAccessFile.setLength(newFileSize);
            this.randomAccessFile.seek(this.randomAccessFile.length());
            this.writer.write(this.commaBytes, this.commaBytes.length);
        } else {
            this.randomAccessFile.setLength(0L);
            this.writer.write(this.bracketOpenBytes, this.bracketOpenBytes.length);
        }
    }

    private void postProcessFile() throws IOException {
        if (this.randomAccessFile.length() > 0L) {
            this.randomAccessFile.seek(this.randomAccessFile.length() - 1L);
            if (this.randomAccessFile.read() == 44) {
                this.randomAccessFile.setLength(this.randomAccessFile.length() - 1L);
            }
        }
        this.writer.write(this.newLineBytes, this.newLineBytes.length);
        this.writer.write(this.bracketCloseBytes, this.bracketCloseBytes.length);
    }

    private static Map<String, Token> createTokens(Map<String, String> properties) {
        FormatPatternParser parser = new FormatPatternParser(properties.get("exception"));
        HashMap<String, Token> tokens = new HashMap<String, Token>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            if (!entry.getKey().toLowerCase(Locale.ROOT).startsWith(FIELD_PREFIX)) continue;
            tokens.put(entry.getKey().substring(FIELD_PREFIX.length()), parser.parse(entry.getValue()));
        }
        return tokens;
    }
}

