/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.path;

import java.io.File;
import org.tinylog.path.Segment;
import org.tinylog.runtime.Timestamp;

final class CountSegment
implements Segment {
    private long count = 0L;

    CountSegment() {
    }

    @Override
    public String getStaticText() {
        return null;
    }

    @Override
    public String createToken(String prefix, Timestamp timestamp) {
        String[] entries;
        String filePrefix;
        File directory;
        int separator = Math.max(prefix.lastIndexOf(File.separatorChar), prefix.lastIndexOf(47));
        if (separator == -1) {
            directory = new File("").getAbsoluteFile();
            filePrefix = prefix;
        } else {
            directory = new File(prefix.substring(0, separator));
            String string = filePrefix = separator == prefix.length() - 1 ? "" : prefix.substring(separator + 1);
        }
        if (directory.isDirectory() && (entries = directory.list()) != null) {
            for (String entry : entries) {
                Long foundCount;
                if (!entry.startsWith(filePrefix) || (foundCount = CountSegment.parseDigits(entry, filePrefix.length())) == null || foundCount + 1L <= this.count) continue;
                this.count = foundCount + 1L;
            }
        }
        return Long.toString(this.count++);
    }

    @Override
    public boolean validateToken(String token) {
        try {
            Long.parseLong(token);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private static Long parseDigits(String text, int start) {
        for (int i = start; i < text.length(); ++i) {
            char character = text.charAt(i);
            if (character >= '0' && character <= '9') continue;
            return CountSegment.parseLong(text.substring(start, i));
        }
        return CountSegment.parseLong(text.substring(start));
    }

    private static Long parseLong(String text) {
        if (text.length() == 0) {
            return null;
        }
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

