/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ServiceLoader;
import org.tinylog.Level;
import org.tinylog.configuration.Configuration;
import org.tinylog.provider.InternalLogger;
import org.tinylog.runtime.RuntimeProvider;
import org.tinylog.writers.Writer;

public final class ConfigurationParser {
    private ConfigurationParser() {
    }

    public static Level getGlobalLevel() {
        return ConfigurationParser.parse(Configuration.get((String)"level"), Level.TRACE);
    }

    public static Map<String, Level> getCustomLevels() {
        HashMap<String, Level> levels = new HashMap<String, Level>();
        for (Map.Entry entry : Configuration.getSiblings((String)"level@").entrySet()) {
            String packageOrClass = ((String)entry.getKey()).substring("level@".length());
            Level level = ConfigurationParser.parse((String)entry.getValue(), null);
            if (level == null) continue;
            levels.put(packageOrClass, level);
        }
        return levels;
    }

    public static List<String> getTags() {
        ArrayList<String> tags = new ArrayList<String>();
        for (String writerProperty : Configuration.getSiblings((String)"writer").keySet()) {
            String tag = Configuration.get((String)(writerProperty + ".tag"));
            if (tag == null || tag.isEmpty() || tag.equals("-") || tags.contains(tag)) continue;
            tags.add(tag);
        }
        return tags;
    }

    public static boolean isWritingThreadEnabled() {
        return "true".equalsIgnoreCase(Configuration.get((String)"writingthread"));
    }

    public static boolean isAutoShutdownEnabled() {
        return !"false".equalsIgnoreCase(Configuration.get((String)"autoshutdown"));
    }

    public static Collection<Writer>[][] createWriters(List<String> tags, Level minimumLevel, boolean writingThread) {
        if (RuntimeProvider.getProcessId() == Long.MIN_VALUE) {
            ServiceLoader.load(Writer.class);
        }
        Collection[][] matrix = new Collection[tags.size() + 2][Level.values().length - 1];
        org.tinylog.configuration.ServiceLoader loader = new org.tinylog.configuration.ServiceLoader(Writer.class, new Class[]{Map.class});
        Map<String, String> writerProperties = Configuration.getSiblings((String)"writer");
        if (writerProperties.isEmpty()) {
            writerProperties = Collections.singletonMap("writer", RuntimeProvider.getDefaultWriter());
        }
        for (Map.Entry entry : writerProperties.entrySet()) {
            String exception;
            Map configuration = Configuration.getChildren((String)((String)entry.getKey()));
            String tag = (String)configuration.get("tag");
            Level level = ConfigurationParser.parse((String)configuration.get("level"), minimumLevel);
            if (level.ordinal() < minimumLevel.ordinal()) {
                level = minimumLevel;
            }
            if ((exception = Configuration.get((String)"exception")) != null && !configuration.containsKey("exception")) {
                configuration.put("exception", exception);
            }
            configuration.remove("tag");
            configuration.remove("level");
            configuration.put("writingthread", Boolean.toString(writingThread));
            Writer writer = (Writer)loader.create((String)entry.getValue(), new Object[]{configuration});
            if (writer == null) continue;
            if (tag == null || tag.isEmpty()) {
                for (int tagIndex = 0; tagIndex < matrix.length; ++tagIndex) {
                    ConfigurationParser.addWriter(writer, matrix, tagIndex, level);
                }
                continue;
            }
            if (tag.equals("-")) {
                ConfigurationParser.addWriter(writer, matrix, 0, level);
                continue;
            }
            ConfigurationParser.addWriter(writer, matrix, tags.indexOf(tag) + 1, level);
        }
        for (int tagIndex = 0; tagIndex < matrix.length; ++tagIndex) {
            for (int levelIndex = 0; levelIndex < matrix[tagIndex].length; ++levelIndex) {
                if (matrix[tagIndex][levelIndex] != null) continue;
                matrix[tagIndex][levelIndex] = Collections.emptyList();
            }
        }
        return matrix;
    }

    private static void addWriter(Writer writer, Collection<Writer>[][] matrix, int tagIndex, Level level) {
        for (int levelIndex = level.ordinal(); levelIndex < Level.OFF.ordinal(); ++levelIndex) {
            Collection<Writer> collection = matrix[tagIndex][levelIndex];
            if (collection == null) {
                matrix[tagIndex][levelIndex] = collection = new ArrayList<Writer>();
            }
            collection.add(writer);
        }
    }

    private static Level parse(String property, Level defaultValue) {
        if (property == null) {
            return defaultValue;
        }
        try {
            return Level.valueOf((String)property.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            InternalLogger.log((Level)Level.ERROR, (String)("Illegal severity level: " + property));
            return defaultValue;
        }
    }
}

