/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.policies;

import java.io.File;
import java.util.Locale;
import org.tinylog.policies.Policy;

public final class SizePolicy
implements Policy {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private final long maximum;
    private long count;

    public SizePolicy(String argument) {
        if (argument == null || argument.isEmpty()) {
            throw new IllegalArgumentException("No maximum size defined for size policy");
        }
        try {
            this.maximum = SizePolicy.parse(argument.toLowerCase(Locale.ROOT));
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Invalid size \"" + argument + "\" for size policy");
        }
        if (this.maximum <= 0L) {
            throw new IllegalArgumentException("Invalid size \"" + argument + "\" for size policy");
        }
    }

    @Override
    public boolean continueExistingFile(String path) {
        File file = new File(path);
        this.count = file.length();
        return this.count <= this.maximum;
    }

    @Override
    public boolean continueCurrentFile(byte[] entry) {
        this.count += (long)entry.length;
        return this.count <= this.maximum;
    }

    @Override
    public void reset() {
        this.count = 0L;
    }

    private static long parse(String argument) throws NumberFormatException {
        if (argument.endsWith("gb")) {
            return Long.parseLong(argument.substring(0, argument.length() - "gb".length()).trim()) * 0x40000000L;
        }
        if (argument.endsWith("mb")) {
            return Long.parseLong(argument.substring(0, argument.length() - "mb".length()).trim()) * 0x100000L;
        }
        if (argument.endsWith("kb")) {
            return Long.parseLong(argument.substring(0, argument.length() - "kb".length()).trim()) * 1024L;
        }
        if (argument.endsWith("bytes")) {
            return Long.parseLong(argument.substring(0, argument.length() - "bytes".length()).trim());
        }
        return Long.parseLong(argument.trim());
    }
}

