/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.runtime;

import java.util.Iterator;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Stream;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.tinylog.Level;
import org.tinylog.provider.InternalLogger;
import org.tinylog.runtime.AbstractJavaRuntime;
import org.tinylog.runtime.PreciseTimestamp;
import org.tinylog.runtime.PreciseTimestampFormatter;
import org.tinylog.runtime.Timestamp;
import org.tinylog.runtime.TimestampFormatter;

@IgnoreJRERequirement
final class ModernJavaRuntime
extends AbstractJavaRuntime {
    private final ProcessHandle currentProcess = ModernJavaRuntime.getCurrentProcess();

    ModernJavaRuntime() {
    }

    @Override
    public long getProcessId() {
        return this.currentProcess.pid();
    }

    @Override
    public String getCallerClassName(int depth) {
        return StackWalker.getInstance().walk(new FixedStackFrameExtractor(depth)).getClassName();
    }

    @Override
    public String getCallerClassName(String loggerClassName) {
        return StackWalker.getInstance().walk(new DynamicStackFrameExtractor(loggerClassName)).getClassName();
    }

    @Override
    public StackTraceElement getCallerStackTraceElement(int depth) {
        return StackWalker.getInstance().walk(new FixedStackFrameExtractor(depth)).toStackTraceElement();
    }

    @Override
    public StackTraceElement getCallerStackTraceElement(String loggerClassName) {
        return StackWalker.getInstance().walk(new DynamicStackFrameExtractor(loggerClassName)).toStackTraceElement();
    }

    @Override
    public Timestamp createTimestamp() {
        return new PreciseTimestamp();
    }

    @Override
    public TimestampFormatter createTimestampFormatter(String pattern, Locale locale) {
        return new PreciseTimestampFormatter(pattern, locale);
    }

    private static ProcessHandle getCurrentProcess() {
        try {
            return (ProcessHandle)ProcessHandle.class.getDeclaredMethod("current", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            InternalLogger.log(Level.ERROR, ex, "Failed to receive the handle of the current process");
            return null;
        }
    }

    @IgnoreJRERequirement
    private static final class DynamicStackFrameExtractor
    implements Function<Stream<StackWalker.StackFrame>, StackWalker.StackFrame> {
        private final String loggerClassName;

        private DynamicStackFrameExtractor(String loggerClassName) {
            this.loggerClassName = loggerClassName;
        }

        @Override
        public StackWalker.StackFrame apply(Stream<StackWalker.StackFrame> stream) {
            Iterator iterator = stream.iterator();
            while (iterator.hasNext() && !this.loggerClassName.equals(((StackWalker.StackFrame)iterator.next()).getClassName())) {
            }
            while (iterator.hasNext()) {
                StackWalker.StackFrame frame = (StackWalker.StackFrame)iterator.next();
                if (this.loggerClassName.equals(frame.getClassName())) continue;
                return frame;
            }
            throw new IllegalStateException("Logger class \"" + this.loggerClassName + "\" is missing in stack trace");
        }
    }

    @IgnoreJRERequirement
    private static final class FixedStackFrameExtractor
    implements Function<Stream<StackWalker.StackFrame>, StackWalker.StackFrame> {
        private final int index;

        private FixedStackFrameExtractor(int index) {
            this.index = index;
        }

        @Override
        public StackWalker.StackFrame apply(Stream<StackWalker.StackFrame> stream) {
            return stream.skip(this.index).findFirst().get();
        }
    }
}

