/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.configuration;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.tinylog.Level;
import org.tinylog.configuration.EnvironmentVariableResolver;
import org.tinylog.configuration.Resolver;
import org.tinylog.configuration.SystemPropertyResolver;
import org.tinylog.provider.InternalLogger;

public final class Configuration {
    private static final String DEFAULT_CONFIGURATION_FILE = "tinylog.properties";
    private static final String PROPERTIES_PREFIX = "tinylog.";
    private static final String CONFIGURATION_PROPERTY = "tinylog.configuration";
    private static final Pattern URL_DETECTION_PATTERN = Pattern.compile("^[a-zA-Z]{2,}:/.*");
    private static final Properties properties = Configuration.load();

    private Configuration() {
    }

    public static String get(String key) {
        return (String)properties.get(key);
    }

    public static Map<String, String> getSiblings(String prefix) {
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (!key.startsWith(prefix) || !prefix.endsWith("@") && key.indexOf(46, prefix.length()) != -1) continue;
            map.put(key, (String)properties.get(key));
        }
        return map;
    }

    public static Map<String, String> getChildren(String key) {
        String prefix = key + ".";
        HashMap<String, String> map = new HashMap<String, String>();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String property = (String)enumeration.nextElement();
            if (!property.startsWith(prefix)) continue;
            map.put(property.substring(prefix.length()), (String)properties.get(property));
        }
        return map;
    }

    public static void set(String key, String value) {
        properties.put(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replace(Map<String, String> configuration) {
        Properties properties = Configuration.properties;
        synchronized (properties) {
            Configuration.properties.clear();
            Configuration.properties.putAll(configuration);
        }
    }

    private static Properties load() {
        Properties properties = new Properties();
        String file = System.getProperty(CONFIGURATION_PROPERTY);
        try {
            InputStream stream;
            if (file != null) {
                if (URL_DETECTION_PATTERN.matcher(file).matches()) {
                    stream = new URL(file).openStream();
                } else {
                    stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(file);
                    if (stream == null) {
                        stream = new FileInputStream(file);
                    }
                }
                Configuration.load(properties, stream);
            } else {
                stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(DEFAULT_CONFIGURATION_FILE);
                if (stream != null) {
                    Configuration.load(properties, stream);
                }
            }
        }
        catch (IOException ex) {
            InternalLogger.log(Level.ERROR, "Failed loading configuration from '" + file + "'");
        }
        for (Object object : new ArrayList<Object>(System.getProperties().keySet())) {
            String name = (String)object;
            if (!name.startsWith(PROPERTIES_PREFIX)) continue;
            properties.put(name.substring(PROPERTIES_PREFIX.length()), System.getProperty(name));
        }
        for (Map.Entry entry : properties.entrySet()) {
            String value = (String)entry.getValue();
            if (value.indexOf(123) == -1) continue;
            value = Configuration.resolve(value, EnvironmentVariableResolver.INSTANCE);
            value = Configuration.resolve(value, SystemPropertyResolver.INSTANCE);
            properties.put(entry.getKey(), value);
        }
        return properties;
    }

    private static void load(Properties properties, InputStream stream) throws IOException {
        try {
            properties.load(stream);
        }
        finally {
            stream.close();
        }
    }

    private static String resolve(String value, Resolver resolver) {
        StringBuilder builder = new StringBuilder();
        int position = 0;
        String prefix = resolver.getPrefix() + "{";
        String postfix = "}";
        int index = value.indexOf(prefix);
        while (index != -1) {
            builder.append(value, position, index);
            int start = index + 2;
            int end = value.indexOf(postfix, start);
            if (end == -1) {
                InternalLogger.log(Level.WARN, "Closing curly bracket is missing for '" + value + "'");
                return value;
            }
            String name = value.substring(start, end);
            if (name.length() == 0) {
                InternalLogger.log(Level.WARN, "Empty variable names cannot be resolved: " + value);
                return value;
            }
            String data = resolver.resolve(name);
            if (data == null) {
                InternalLogger.log(Level.WARN, "'" + name + "' could not be found in " + resolver.getName());
                return value;
            }
            builder.append(data);
            position = end + 1;
            index = value.indexOf(prefix, position);
        }
        builder.append(value, position, value.length());
        return builder.toString();
    }
}

