/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.jul;

import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.tinylog.Level;
import org.tinylog.configuration.Configuration;
import org.tinylog.format.JavaTextMessageFormatFormatter;
import org.tinylog.format.MessageFormatter;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

final class BridgeHandler
extends Handler {
    private static final String LOGGER_CLASS_NAME = Logger.class.getName();
    private static final MessageFormatter formatter = new JavaTextMessageFormatFormatter(Configuration.getLocale());
    private static final LoggingProvider provider = ProviderRegistry.getLoggingProvider();

    BridgeHandler() {
    }

    @Override
    public void publish(LogRecord record) {
        provider.log(LOGGER_CLASS_NAME, null, BridgeHandler.translateLevel(record.getLevel()), record.getThrown(), formatter, (Object)record.getMessage(), record.getParameters());
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    void activate() {
        LogManager.getLogManager().reset();
        Logger logger = Logger.getLogger("");
        logger.setLevel(BridgeHandler.translateLevel(provider.getMinimumLevel(null)));
        logger.addHandler(this);
    }

    private static java.util.logging.Level translateLevel(Level level) {
        switch (level) {
            case TRACE: {
                return java.util.logging.Level.ALL;
            }
            case DEBUG: {
                return java.util.logging.Level.FINER;
            }
            case INFO: {
                return java.util.logging.Level.CONFIG;
            }
            case WARN: {
                return java.util.logging.Level.WARNING;
            }
            case ERROR: {
                return java.util.logging.Level.SEVERE;
            }
            case OFF: {
                return java.util.logging.Level.OFF;
            }
        }
        throw new IllegalArgumentException("Unknown JUL severity level \"" + level + "\"");
    }

    private static Level translateLevel(java.util.logging.Level level) {
        if (level.intValue() <= java.util.logging.Level.FINEST.intValue()) {
            return Level.TRACE;
        }
        if (level.intValue() <= java.util.logging.Level.FINE.intValue()) {
            return Level.DEBUG;
        }
        if (level.intValue() <= java.util.logging.Level.INFO.intValue()) {
            return Level.INFO;
        }
        if (level.intValue() <= java.util.logging.Level.WARNING.intValue()) {
            return Level.WARN;
        }
        return Level.ERROR;
    }
}

