/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.txn;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.PDClient;
import org.tikv.common.TiConfiguration;
import org.tikv.common.exception.KeyException;
import org.tikv.common.exception.RegionException;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.operation.KVErrorHandler;
import org.tikv.common.region.AbstractRegionStoreClient;
import org.tikv.common.region.RegionManager;
import org.tikv.common.region.RegionStoreClient;
import org.tikv.common.region.TiRegion;
import org.tikv.common.region.TiStore;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.ChannelFactory;
import org.tikv.common.util.TsoUtils;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.kvproto.TikvGrpc;
import org.tikv.shade.com.google.protobuf.ByteString;
import org.tikv.txn.AbstractLockResolverClient;
import org.tikv.txn.Lock;
import org.tikv.txn.ResolveLockResult;
import org.tikv.txn.TxnExpireTime;
import org.tikv.txn.TxnStatus;
import org.tikv.txn.exception.TxnNotFoundException;
import org.tikv.txn.exception.WriteConflictException;

public class LockResolverClientV4
extends AbstractRegionStoreClient
implements AbstractLockResolverClient {
    private static final Logger logger = LoggerFactory.getLogger(LockResolverClientV4.class);
    private final ReadWriteLock readWriteLock;
    private final Map<Long, TxnStatus> resolved = new HashMap<Long, TxnStatus>();
    private final Queue<Long> recentResolved = new LinkedList<Long>();
    private final PDClient pdClient;
    private final RegionStoreClient.RegionStoreClientBuilder clientBuilder;

    public LockResolverClientV4(TiConfiguration conf, TiRegion region, TiStore store, TikvGrpc.TikvBlockingStub blockingStub, TikvGrpc.TikvFutureStub asyncStub, ChannelFactory channelFactory, RegionManager regionManager, PDClient pdClient, RegionStoreClient.RegionStoreClientBuilder clientBuilder) {
        super(conf, region, store, channelFactory, blockingStub, asyncStub, regionManager);
        this.readWriteLock = new ReentrantReadWriteLock();
        this.pdClient = pdClient;
        this.clientBuilder = clientBuilder;
    }

    @Override
    public String getVersion() {
        return "V4";
    }

    @Override
    public ResolveLockResult resolveLocks(BackOffer bo, long callerStartTS, List<Lock> locks, boolean forWrite) {
        TxnExpireTime msBeforeTxnExpired = new TxnExpireTime();
        if (locks.isEmpty()) {
            return new ResolveLockResult(msBeforeTxnExpired.value());
        }
        HashMap<Long, Set> cleanTxns = new HashMap<Long, Set>();
        boolean pushFail = false;
        HashSet<Long> pushed = new HashSet<Long>(locks.size());
        for (Lock l : locks) {
            TxnStatus status = this.getTxnStatusFromLock(bo, l, callerStartTS);
            if (status.getTtl() == 0L) {
                Set cleanRegion = cleanTxns.computeIfAbsent(l.getTxnID(), k -> new HashSet());
                if (l.getLockType() == Kvrpcpb.Op.PessimisticLock) {
                    this.resolvePessimisticLock(bo, l, cleanRegion);
                    continue;
                }
                this.resolveLock(bo, l, status, cleanRegion);
                continue;
            }
            long msBeforeLockExpired = TsoUtils.untilExpired(l.getTxnID(), status.getTtl());
            msBeforeTxnExpired.update(msBeforeLockExpired);
            if (forWrite) {
                if (l.getLockType() == Kvrpcpb.Op.PessimisticLock || l.getTxnID() <= callerStartTS) continue;
                throw new WriteConflictException(callerStartTS, l.getTxnID(), status.getCommitTS(), l.getKey().toByteArray());
            }
            if (status.getAction() != Kvrpcpb.Action.MinCommitTSPushed) {
                pushFail = true;
                continue;
            }
            pushed.add(l.getTxnID());
        }
        if (pushFail) {
            pushed = new HashSet();
        }
        return new ResolveLockResult(msBeforeTxnExpired.value(), pushed);
    }

    private void resolvePessimisticLock(BackOffer bo, Lock lock, Set<TiRegion.RegionVerID> cleanRegion) {
        Kvrpcpb.PessimisticRollbackResponse resp2;
        while (true) {
            this.region = this.regionManager.getRegionByKey(lock.getKey());
            if (cleanRegion.contains(this.region.getVerID())) {
                return;
            }
            long forUpdateTS = lock.getLockForUpdateTs() == 0L ? Long.MAX_VALUE : lock.getLockForUpdateTs();
            Supplier<Kvrpcpb.PessimisticRollbackRequest> factory = () -> Kvrpcpb.PessimisticRollbackRequest.newBuilder().setContext(this.makeContext()).addKeys(this.codec.encodeKey(lock.getKey())).setStartVersion(lock.getTxnID()).setForUpdateTs(forUpdateTS).build();
            KVErrorHandler<Kvrpcpb.PessimisticRollbackResponse> handler = new KVErrorHandler<Kvrpcpb.PessimisticRollbackResponse>(this.regionManager, this, this, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> resp.getErrorsCount() > 0 ? resp.getErrorsList().get(0) : null, resolveLockResult -> null, 0L, false);
            resp2 = this.callWithRetry(bo, TikvGrpc.getKVPessimisticRollbackMethod(), factory, handler);
            if (resp2 == null) {
                logger.error("getKVPessimisticRollbackMethod failed without a cause");
                this.regionManager.onRequestFail(this.region);
                bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new TiClientInternalException("getKVPessimisticRollbackMethod failed without a cause"));
                continue;
            }
            if (resp2.hasRegionError()) {
                bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new RegionException(resp2.getRegionError()));
                continue;
            }
            if (resp2.getErrorsCount() > 0) break;
        }
        logger.error(String.format("unexpected resolveLock err: %s, lock: %s", resp2.getErrorsList().get(0), lock));
        throw new KeyException(resp2.getErrorsList().get(0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TxnStatus getTxnStatusFromLock(BackOffer bo, Lock lock, long callerStartTS) {
        long currentTS = lock.getTtl() == 0L ? Long.MAX_VALUE : this.pdClient.getTimestamp(bo).getVersion();
        boolean rollbackIfNotExist = false;
        while (true) {
            try {
                return this.getTxnStatus(bo, lock.getTxnID(), lock.getPrimary(), callerStartTS, currentTS, rollbackIfNotExist);
            }
            catch (TxnNotFoundException e) {
                logger.warn("getTxnStatus error!", (Throwable)e);
                bo.doBackOff(BackOffFunction.BackOffFuncType.BoTxnNotFound, e);
                if (TsoUtils.untilExpired(lock.getTxnID(), lock.getTtl()) <= 0L) {
                    logger.warn(String.format("lock txn not found, lock has expired, CallerStartTs=%d lock str=%s", callerStartTS, lock));
                    if (lock.getLockType() == Kvrpcpb.Op.PessimisticLock) {
                        return new TxnStatus();
                    }
                    rollbackIfNotExist = true;
                    continue;
                }
                if (lock.getLockType() == Kvrpcpb.Op.PessimisticLock) return new TxnStatus(lock.getTtl());
                continue;
            }
            break;
        }
    }

    private TxnStatus getTxnStatus(BackOffer bo, Long txnID, ByteString primary, Long callerStartTS, Long currentTS, boolean rollbackIfNotExist) {
        Kvrpcpb.CheckTxnStatusResponse resp2;
        TxnStatus status = this.getResolved(txnID);
        if (status != null) {
            return status;
        }
        Supplier<Kvrpcpb.CheckTxnStatusRequest> factory = () -> {
            TiRegion primaryKeyRegion = this.regionManager.getRegionByKey(primary);
            return Kvrpcpb.CheckTxnStatusRequest.newBuilder().setContext(primaryKeyRegion.getLeaderContext()).setPrimaryKey(this.codec.encodeKey(primary)).setLockTs(txnID).setCallerStartTs(callerStartTS).setCurrentTs(currentTS).setRollbackIfNotExist(rollbackIfNotExist).build();
        };
        while (true) {
            TiRegion primaryKeyRegion = this.regionManager.getRegionByKey(primary);
            RegionStoreClient primaryKeyRegionStoreClient = this.clientBuilder.build(primary);
            KVErrorHandler<Kvrpcpb.CheckTxnStatusResponse> handler = new KVErrorHandler<Kvrpcpb.CheckTxnStatusResponse>(this.regionManager, primaryKeyRegionStoreClient, primaryKeyRegionStoreClient.lockResolverClient, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> resp.hasError() ? resp.getError() : null, resolveLockResult -> null, callerStartTS, false);
            resp2 = primaryKeyRegionStoreClient.callWithRetry(bo, TikvGrpc.getKvCheckTxnStatusMethod(), factory, handler);
            if (resp2 == null) {
                logger.error("getKvCheckTxnStatusMethod failed without a cause");
                this.regionManager.onRequestFail(primaryKeyRegion);
                bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new TiClientInternalException("getKvCheckTxnStatusMethod failed without a cause"));
                continue;
            }
            if (!resp2.hasRegionError()) break;
            bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new RegionException(resp2.getRegionError()));
        }
        if (resp2.hasError()) {
            Kvrpcpb.KeyError keyError = resp2.getError();
            if (keyError.hasTxnNotFound()) {
                throw new TxnNotFoundException();
            }
            logger.error(String.format("unexpected cleanup err: %s, tid: %d", keyError, txnID));
            throw new KeyException(keyError);
        }
        if (resp2.getLockTtl() != 0L) {
            status = new TxnStatus(resp2.getLockTtl(), 0L, resp2.getAction());
        } else {
            status = new TxnStatus(0L, resp2.getCommitVersion(), resp2.getAction());
            this.saveResolved(txnID, status);
        }
        return status;
    }

    private void resolveLock(BackOffer bo, Lock lock, TxnStatus txnStatus, Set<TiRegion.RegionVerID> cleanRegion) {
        Kvrpcpb.ResolveLockResponse resp2;
        boolean cleanWholeRegion = lock.getTxnSize() >= 16L;
        while (true) {
            this.region = this.regionManager.getRegionByKey(lock.getKey());
            if (cleanRegion.contains(this.region.getVerID())) {
                return;
            }
            Kvrpcpb.ResolveLockRequest.Builder builder = Kvrpcpb.ResolveLockRequest.newBuilder().setContext(this.makeContext()).setStartVersion(lock.getTxnID());
            if (txnStatus.isCommitted()) {
                builder.setCommitVersion(txnStatus.getCommitTS());
            }
            if (lock.getTxnSize() < 16L) {
                builder.addKeys(this.codec.encodeKey(lock.getKey()));
            }
            Supplier<Kvrpcpb.ResolveLockRequest> factory = builder::build;
            KVErrorHandler<Kvrpcpb.ResolveLockResponse> handler = new KVErrorHandler<Kvrpcpb.ResolveLockResponse>(this.regionManager, this, this, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> resp.hasError() ? resp.getError() : null, resolveLockResult -> null, 0L, false);
            resp2 = this.callWithRetry(bo, TikvGrpc.getKvResolveLockMethod(), factory, handler);
            if (resp2 == null) {
                logger.error("getKvResolveLockMethod failed without a cause");
                this.regionManager.onRequestFail(this.region);
                bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new TiClientInternalException("getKvResolveLockMethod failed without a cause"));
                continue;
            }
            if (!resp2.hasRegionError()) break;
            bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new RegionException(resp2.getRegionError()));
        }
        if (resp2.hasError()) {
            logger.error(String.format("unexpected resolveLock err: %s, lock: %s", resp2.getError(), lock));
            throw new KeyException(resp2.getError());
        }
        if (cleanWholeRegion) {
            cleanRegion.add(this.region.getVerID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveResolved(long txnID, TxnStatus status) {
        try {
            this.readWriteLock.writeLock().lock();
            if (this.resolved.containsKey(txnID)) {
                return;
            }
            this.resolved.put(txnID, status);
            this.recentResolved.add(txnID);
            if ((long)this.recentResolved.size() > 2048L) {
                Long front = this.recentResolved.remove();
                this.resolved.remove(front);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private TxnStatus getResolved(Long txnID) {
        try {
            this.readWriteLock.readLock().lock();
            TxnStatus txnStatus = this.resolved.get(txnID);
            return txnStatus;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }
}

