/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.util;

import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.tikv.common.key.Key;
import org.tikv.common.key.RowKey;
import org.tikv.common.pd.PDUtils;
import org.tikv.common.region.RegionManager;
import org.tikv.common.region.TiRegion;
import org.tikv.common.region.TiStore;
import org.tikv.common.region.TiStoreType;
import org.tikv.common.util.FastByteComparisons;
import org.tikv.common.util.KeyRangeUtils;
import org.tikv.common.util.Pair;
import org.tikv.kvproto.Coprocessor;
import org.tikv.shade.com.google.common.collect.ImmutableList;
import org.tikv.shade.com.google.protobuf.ByteString;

public class RangeSplitter {
    private final RegionManager regionManager;

    private RangeSplitter(RegionManager regionManager) {
        this.regionManager = regionManager;
    }

    public static RangeSplitter newSplitter(RegionManager mgr) {
        return new RangeSplitter(mgr);
    }

    public Map<Pair<TiRegion, TiStore>, TLongArrayList> groupByAndSortHandlesByRegionId(long tableId, TLongArrayList handles) {
        TLongObjectHashMap<TLongArrayList> regionHandles = new TLongObjectHashMap<TLongArrayList>();
        TLongObjectHashMap<Pair<TiRegion, TiStore>> idToRegionStorePair = new TLongObjectHashMap<Pair<TiRegion, TiStore>>();
        HashMap<Pair<TiRegion, TiStore>, TLongArrayList> result = new HashMap<Pair<TiRegion, TiStore>, TLongArrayList>();
        handles.sort();
        byte[] endKey = null;
        TiRegion curRegion = null;
        TLongArrayList handlesInCurRegion = new TLongArrayList();
        for (int i = 0; i < handles.size(); ++i) {
            long curHandle = handles.get(i);
            RowKey key = RowKey.toRowKey(tableId, curHandle);
            if (endKey == null || endKey.length != 0 && FastByteComparisons.compareTo(key.getBytes(), endKey) >= 0) {
                if (curRegion != null) {
                    regionHandles.put(curRegion.getId(), handlesInCurRegion);
                    handlesInCurRegion = new TLongArrayList();
                }
                Pair<TiRegion, TiStore> regionStorePair = this.regionManager.getRegionStorePairByKey(ByteString.copyFrom(key.getBytes()));
                curRegion = (TiRegion)regionStorePair.first;
                idToRegionStorePair.put(curRegion.getId(), regionStorePair);
                endKey = curRegion.getEndKey().toByteArray();
            }
            handlesInCurRegion.add(curHandle);
        }
        if (!handlesInCurRegion.isEmpty() && curRegion != null) {
            regionHandles.put(curRegion.getId(), handlesInCurRegion);
        }
        regionHandles.forEachEntry((k, v) -> {
            Pair regionStorePair = (Pair)idToRegionStorePair.get(k);
            result.put(regionStorePair, (TLongArrayList)v);
            return true;
        });
        return result;
    }

    public List<RegionTask> splitAndSortHandlesByRegion(List<Long> ids, TLongArrayList handles) {
        HashSet<RegionTask> regionTasks = new HashSet<RegionTask>();
        for (Long id : ids) {
            regionTasks.addAll(this.splitAndSortHandlesByRegion(id, handles));
        }
        return new ArrayList<RegionTask>(regionTasks);
    }

    private List<RegionTask> splitAndSortHandlesByRegion(long tableId, TLongArrayList handles) {
        ImmutableList.Builder regionTasks = ImmutableList.builder();
        Map<Pair<TiRegion, TiStore>, TLongArrayList> regionHandlesMap = this.groupByAndSortHandlesByRegionId(tableId, handles);
        regionHandlesMap.forEach((k, v) -> this.createTask(0, v.size(), tableId, (TLongArrayList)v, (Pair<TiRegion, TiStore>)k, regionTasks));
        return regionTasks.build();
    }

    private void createTask(int startPos, int endPos, long tableId, TLongArrayList handles, Pair<TiRegion, TiStore> regionStorePair, ImmutableList.Builder<RegionTask> regionTasks) {
        long startHandle;
        ArrayList<Coprocessor.KeyRange> newKeyRanges = new ArrayList<Coprocessor.KeyRange>(endPos - startPos + 1);
        long endHandle = startHandle = handles.get(startPos);
        for (int i = startPos + 1; i < endPos; ++i) {
            long curHandle = handles.get(i);
            if (endHandle + 1L == curHandle) {
                endHandle = curHandle;
                continue;
            }
            newKeyRanges.add(KeyRangeUtils.makeCoprocRange(RowKey.toRowKey(tableId, startHandle).toByteString(), RowKey.toRowKey(tableId, endHandle + 1L).toByteString()));
            endHandle = startHandle = curHandle;
        }
        newKeyRanges.add(KeyRangeUtils.makeCoprocRange(RowKey.toRowKey(tableId, startHandle).toByteString(), RowKey.toRowKey(tableId, endHandle + 1L).toByteString()));
        regionTasks.add((Object)new RegionTask((TiRegion)regionStorePair.first, (TiStore)regionStorePair.second, newKeyRanges));
    }

    public List<RegionTask> splitRangeByRegion(List<Coprocessor.KeyRange> keyRanges, TiStoreType storeType) {
        if (keyRanges == null || keyRanges.size() == 0) {
            return ImmutableList.of();
        }
        int i = 0;
        Coprocessor.KeyRange range = keyRanges.get(i++);
        HashMap<Long, List> idToRange = new HashMap<Long, List>();
        HashMap<Long, Pair<TiRegion, TiStore>> idToRegion = new HashMap<Long, Pair<TiRegion, TiStore>>();
        while (true) {
            Pair<TiRegion, TiStore> regionStorePair;
            if ((regionStorePair = this.regionManager.getRegionStorePairByKey(range.getStart(), storeType)) == null) {
                throw new NullPointerException("fail to get region/store pair by key " + KeyRangeUtils.formatByteString(range.getStart()));
            }
            TiRegion region = (TiRegion)regionStorePair.first;
            idToRegion.putIfAbsent(region.getId(), regionStorePair);
            if (Key.toRawKey(range.getEnd()).compareTo(Key.toRawKey(region.getEndKey())) > 0) {
                Coprocessor.KeyRange cutRange = Coprocessor.KeyRange.newBuilder().setStart(range.getStart()).setEnd(region.getEndKey()).build();
                List ranges = idToRange.computeIfAbsent(region.getId(), k -> new ArrayList());
                ranges.add(cutRange);
                range = Coprocessor.KeyRange.newBuilder().setStart(region.getEndKey()).setEnd(range.getEnd()).build();
                continue;
            }
            List ranges = idToRange.computeIfAbsent(region.getId(), k -> new ArrayList());
            ranges.add(range);
            if (i >= keyRanges.size()) break;
            range = keyRanges.get(i++);
        }
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        idToRange.forEach((k, v) -> {
            Pair regionStorePair = (Pair)idToRegion.get(k);
            resultBuilder.add(new RegionTask((TiRegion)regionStorePair.first, (TiStore)regionStorePair.second, (List<Coprocessor.KeyRange>)v));
        });
        return resultBuilder.build();
    }

    public List<RegionTask> splitRangeByRegion(List<Coprocessor.KeyRange> keyRanges) {
        return this.splitRangeByRegion(keyRanges, TiStoreType.TiKV);
    }

    public static class RegionTask
    implements Serializable {
        private final TiRegion region;
        private final TiStore store;
        private final List<Coprocessor.KeyRange> ranges;
        private final String host;

        RegionTask(TiRegion region, TiStore store, List<Coprocessor.KeyRange> ranges) {
            this.region = region;
            this.store = store;
            this.ranges = ranges;
            String host = null;
            try {
                host = PDUtils.addrToUri(store.getStore().getAddress()).getHost();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.host = host;
        }

        public static RegionTask newInstance(TiRegion region, TiStore store, List<Coprocessor.KeyRange> ranges) {
            return new RegionTask(region, store, ranges);
        }

        public TiRegion getRegion() {
            return this.region;
        }

        public TiStore getStore() {
            return this.store;
        }

        public List<Coprocessor.KeyRange> getRanges() {
            return this.ranges;
        }

        public String getHost() {
            return this.host;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Region [%s]", this.region));
            sb.append(" ");
            for (Coprocessor.KeyRange range : this.ranges) {
                sb.append(String.format("Range Start: [%s] Range End: [%s]", KeyRangeUtils.formatByteString(range.getStart()), KeyRangeUtils.formatByteString(range.getEnd())));
            }
            return sb.toString();
        }
    }
}

