/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.types;

import java.sql.Timestamp;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.tikv.common.ExtendedDateTime;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.exception.ConvertNotSupportException;
import org.tikv.common.exception.ConvertOverflowException;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.types.AbstractDateTimeType;
import org.tikv.common.types.Converter;
import org.tikv.common.types.MySQLType;

public class TimestampType
extends AbstractDateTimeType {
    public static final TimestampType TIMESTAMP = new TimestampType(MySQLType.TypeTimestamp);
    public static final MySQLType[] subTypes = new MySQLType[]{MySQLType.TypeTimestamp};

    TimestampType(MySQLType tp) {
        super(tp);
    }

    TimestampType(TiColumnInfo.InternalTypeHolder holder) {
        super(holder);
    }

    @Override
    public DateTimeZone getTimezone() {
        return DateTimeZone.UTC;
    }

    @Override
    protected Object doConvertToTiDBType(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        return this.convertToMysqlLocalTimestamp(value);
    }

    private Timestamp convertToMysqlLocalTimestamp(Object value) throws ConvertNotSupportException {
        if (value instanceof Long) {
            throw new ConvertNotSupportException(value.getClass().getName(), this.getClass().getName());
        }
        return this.convertToMysqlDateTime(value);
    }

    @Override
    protected Long decodeNotNull(int flag, CodecDataInput cdi) {
        return this.decodeDateTime(flag, cdi);
    }

    @Override
    protected Timestamp decodeNotNullForBatchWrite(int flag, CodecDataInput cdi) {
        return this.decodeDateTimeForBatchWrite(flag, cdi);
    }

    @Override
    public DateTime getOriginDefaultValueNonNull(String value, long version) {
        if (version >= 1L) {
            LocalDateTime localDateTime = Converter.strToDateTime(value, Converter.UTC_TIME_FORMATTER).withZone(DateTimeZone.getDefault()).toLocalDateTime();
            return localDateTime.toDateTime();
        }
        return Converter.convertToDateTime(value).getDateTime();
    }

    @Override
    protected void encodeProto(CodecDataOutput cdo, Object value) {
        ExtendedDateTime localExtendedDateTime = Converter.convertToDateTime(value);
        DateTime utcDateTime = localExtendedDateTime.getDateTime().toDateTime(DateTimeZone.UTC);
        ExtendedDateTime utcExtendedDateTime = new ExtendedDateTime(utcDateTime, localExtendedDateTime.getMicrosOfMillis());
        Codec.DateTimeCodec.writeDateTimeProto(cdo, utcExtendedDateTime, Converter.getLocalTimezone());
    }

    @Override
    public String getName() {
        return "TIMESTAMP";
    }
}

