/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.region;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.tikv.common.region.TiStoreType;
import org.tikv.kvproto.Metapb;

public class TiStore
implements Serializable {
    private final Metapb.Store store;
    private final Metapb.Store proxyStore;
    private final AtomicBoolean reachable;
    private final AtomicBoolean valid;

    public TiStore(Metapb.Store store) {
        this.store = store;
        this.reachable = new AtomicBoolean(true);
        this.valid = new AtomicBoolean(true);
        this.proxyStore = null;
    }

    private TiStore(Metapb.Store store, Metapb.Store proxyStore) {
        this.store = store;
        this.reachable = proxyStore != null ? new AtomicBoolean(false) : new AtomicBoolean(true);
        this.valid = new AtomicBoolean(true);
        this.proxyStore = proxyStore;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TiStore)) {
            return super.equals(obj);
        }
        TiStore other = (TiStore)obj;
        if (!this.store.equals(other.store)) {
            return false;
        }
        if (this.proxyStore == null && other.proxyStore == null) {
            return true;
        }
        if (this.proxyStore != null && other.proxyStore != null) {
            return this.proxyStore.equals(other.proxyStore);
        }
        return false;
    }

    public TiStore withProxy(Metapb.Store proxyStore) {
        return new TiStore(this.store, proxyStore);
    }

    public void markUnreachable() {
        this.reachable.set(false);
    }

    public void markReachable() {
        this.reachable.set(true);
    }

    public boolean isReachable() {
        return this.reachable.get();
    }

    public boolean isValid() {
        return this.valid.get();
    }

    public void markInvalid() {
        this.valid.set(false);
    }

    public Metapb.Store getStore() {
        return this.store;
    }

    public String getAddress() {
        return this.store.getAddress();
    }

    public Metapb.Store getProxyStore() {
        return this.proxyStore;
    }

    public long getId() {
        return this.store.getId();
    }

    public boolean isTiFlash() {
        for (Metapb.StoreLabel label : this.store.getLabelsList()) {
            if (!label.getKey().equals(TiStoreType.TiFlash.getLabelKey()) || !label.getValue().equals(TiStoreType.TiFlash.getLabelValue())) continue;
            return true;
        }
        return false;
    }
}

