/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.region;

import com.pingcap.tidb.tipb.DAGRequest;
import com.pingcap.tidb.tipb.SelectResponse;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.PDClient;
import org.tikv.common.StoreVersion;
import org.tikv.common.TiConfiguration;
import org.tikv.common.exception.GrpcException;
import org.tikv.common.exception.KeyException;
import org.tikv.common.exception.RawCASConflictException;
import org.tikv.common.exception.RegionException;
import org.tikv.common.exception.SelectException;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.exception.TiKVException;
import org.tikv.common.log.SlowLogEmptyImpl;
import org.tikv.common.operation.KVErrorHandler;
import org.tikv.common.operation.RegionErrorHandler;
import org.tikv.common.region.AbstractRegionStoreClient;
import org.tikv.common.region.RegionManager;
import org.tikv.common.region.TiRegion;
import org.tikv.common.region.TiStore;
import org.tikv.common.region.TiStoreType;
import org.tikv.common.streaming.StreamingResponse;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.Batch;
import org.tikv.common.util.ChannelFactory;
import org.tikv.common.util.ConcreteBackOffer;
import org.tikv.common.util.HistogramUtils;
import org.tikv.common.util.Pair;
import org.tikv.common.util.RangeSplitter;
import org.tikv.kvproto.Coprocessor;
import org.tikv.kvproto.Errorpb;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.kvproto.Metapb;
import org.tikv.kvproto.TikvGrpc;
import org.tikv.shade.com.google.common.annotations.VisibleForTesting;
import org.tikv.shade.com.google.protobuf.ByteString;
import org.tikv.shade.com.google.protobuf.InvalidProtocolBufferException;
import org.tikv.shade.io.grpc.ManagedChannel;
import org.tikv.shade.io.grpc.Metadata;
import org.tikv.shade.io.grpc.stub.MetadataUtils;
import org.tikv.shade.io.prometheus.client.Histogram;
import org.tikv.txn.AbstractLockResolverClient;
import org.tikv.txn.Lock;
import org.tikv.txn.ResolveLockResult;
import org.tikv.txn.exception.LockException;

public class RegionStoreClient
extends AbstractRegionStoreClient {
    private static final Logger logger = LoggerFactory.getLogger(RegionStoreClient.class);
    @VisibleForTesting
    public final AbstractLockResolverClient lockResolverClient;
    private final TiStoreType storeType;
    private final Map<Long, Set<Long>> resolvedLocks = new HashMap<Long, Set<Long>>();
    private final PDClient pdClient;
    private Boolean isV4 = null;
    public static final Histogram GRPC_RAW_REQUEST_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)HistogramUtils.buildDuration().name("client_java_grpc_raw_requests_latency")).help("grpc raw request latency.")).labelNames("type", "cluster")).register();

    private synchronized Boolean getIsV4() {
        if (this.isV4 == null) {
            this.isV4 = StoreVersion.minTiKVVersion("4.0.0", this.pdClient);
        }
        return this.isV4;
    }

    private RegionStoreClient(TiConfiguration conf, TiRegion region, TiStore store, TiStoreType storeType, ChannelFactory channelFactory, TikvGrpc.TikvBlockingStub blockingStub, TikvGrpc.TikvFutureStub asyncStub, RegionManager regionManager, PDClient pdClient, RegionStoreClientBuilder clientBuilder) {
        super(conf, region, store, channelFactory, blockingStub, asyncStub, regionManager);
        this.storeType = storeType;
        if (this.storeType == TiStoreType.TiKV) {
            this.lockResolverClient = AbstractLockResolverClient.getInstance(conf, region, store, (TikvGrpc.TikvBlockingStub)this.blockingStub, (TikvGrpc.TikvFutureStub)this.asyncStub, channelFactory, regionManager, pdClient, clientBuilder);
        } else {
            TiStore tikvStore = (TiStore)regionManager.getRegionStorePairByKey((ByteString)region.getStartKey(), (TiStoreType)TiStoreType.TiKV).second;
            String addressStr = tikvStore.getStore().getAddress();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Create region store client on address %s", addressStr));
            }
            ManagedChannel channel = channelFactory.getChannel(addressStr, pdClient.getHostMapping());
            TikvGrpc.TikvBlockingStub tikvBlockingStub = TikvGrpc.newBlockingStub(channel);
            TikvGrpc.TikvFutureStub tikvAsyncStub = TikvGrpc.newFutureStub(channel);
            this.lockResolverClient = AbstractLockResolverClient.getInstance(conf, region, tikvStore, tikvBlockingStub, tikvAsyncStub, channelFactory, regionManager, pdClient, clientBuilder);
        }
        this.pdClient = pdClient;
    }

    public synchronized boolean addResolvedLocks(Long version, Set<Long> locks) {
        Set<Long> oldList = this.resolvedLocks.get(version);
        if (oldList != null) {
            oldList.addAll(locks);
        } else {
            this.resolvedLocks.put(version, new HashSet<Long>(locks));
        }
        return true;
    }

    public synchronized Set<Long> getResolvedLocks(Long version) {
        return this.resolvedLocks.getOrDefault(version, Collections.emptySet());
    }

    public ByteString get(BackOffer backOffer, ByteString key, long version) throws TiClientInternalException, KeyException {
        boolean forWrite = false;
        Supplier<Kvrpcpb.GetRequest> factory = () -> Kvrpcpb.GetRequest.newBuilder().setContext(this.makeContext(this.getResolvedLocks(version), this.storeType, backOffer.getSlowLog())).setKey(this.codec.encodeKey(key)).setVersion(version).build();
        KVErrorHandler<Kvrpcpb.GetResponse> handler = new KVErrorHandler<Kvrpcpb.GetResponse>(this.regionManager, this, this.lockResolverClient, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> resp.hasError() ? resp.getError() : null, resolveLockResult -> this.addResolvedLocks(version, resolveLockResult.getResolvedLocks()), version, forWrite);
        Kvrpcpb.GetResponse resp2 = this.callWithRetry(backOffer, TikvGrpc.getKvGetMethod(), factory, handler);
        this.handleGetResponse(resp2);
        return resp2.getValue();
    }

    private void handleGetResponse(Kvrpcpb.GetResponse resp) throws TiClientInternalException, KeyException {
        if (resp == null) {
            this.regionManager.onRequestFail(this.region);
            throw new TiClientInternalException("GetResponse failed without a cause");
        }
        if (resp.hasRegionError()) {
            throw new RegionException(resp.getRegionError());
        }
        if (resp.hasError()) {
            throw new KeyException(resp.getError());
        }
    }

    public List<Kvrpcpb.KvPair> batchGet(BackOffer backOffer, List<ByteString> keys, long version) {
        boolean forWrite = false;
        Supplier<Kvrpcpb.BatchGetRequest> request = () -> Kvrpcpb.BatchGetRequest.newBuilder().setContext(this.makeContext(this.getResolvedLocks(version), this.storeType, backOffer.getSlowLog())).addAllKeys(this.codec.encodeKeys(keys)).setVersion(version).build();
        KVErrorHandler<Kvrpcpb.BatchGetResponse> handler = new KVErrorHandler<Kvrpcpb.BatchGetResponse>(this.regionManager, this, this.lockResolverClient, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> null, resolveLockResult -> this.addResolvedLocks(version, resolveLockResult.getResolvedLocks()), version, forWrite);
        Kvrpcpb.BatchGetResponse resp2 = this.callWithRetry(backOffer, TikvGrpc.getKvBatchGetMethod(), request, handler);
        return this.handleBatchGetResponse(backOffer, resp2, version);
    }

    private List<Kvrpcpb.KvPair> handleBatchGetResponse(BackOffer backOffer, Kvrpcpb.BatchGetResponse resp, long version) {
        boolean forWrite = false;
        if (resp == null) {
            this.regionManager.onRequestFail(this.region);
            throw new TiClientInternalException("BatchGetResponse failed without a cause");
        }
        if (resp.hasRegionError()) {
            throw new RegionException(resp.getRegionError());
        }
        ArrayList<Lock> locks = new ArrayList<Lock>();
        for (Kvrpcpb.KvPair pair : resp.getPairsList()) {
            if (!pair.hasError()) continue;
            if (pair.getError().hasLocked()) {
                Lock lock = new Lock(pair.getError().getLocked(), this.codec);
                locks.add(lock);
                continue;
            }
            throw new KeyException(pair.getError());
        }
        if (!locks.isEmpty()) {
            ResolveLockResult resolveLockResult = this.lockResolverClient.resolveLocks(backOffer, version, locks, forWrite);
            this.addResolvedLocks(version, resolveLockResult.getResolvedLocks());
            throw new TiKVException("locks not resolved, retry");
        }
        return this.codec.decodeKvPairs(resp.getPairsList());
    }

    public List<Kvrpcpb.KvPair> scan(BackOffer backOffer, ByteString startKey, long version, boolean keyOnly) {
        Kvrpcpb.ScanResponse resp2;
        boolean forWrite = false;
        do {
            Supplier<Kvrpcpb.ScanRequest> request = () -> Kvrpcpb.ScanRequest.newBuilder().setContext(this.makeContext(this.getResolvedLocks(version), this.storeType, backOffer.getSlowLog())).setStartKey(this.codec.encodeKey(startKey)).setVersion(version).setKeyOnly(keyOnly).setLimit(this.getConf().getScanBatchSize()).build();
            KVErrorHandler<Kvrpcpb.ScanResponse> handler = new KVErrorHandler<Kvrpcpb.ScanResponse>(this.regionManager, this, this.lockResolverClient, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> resp.hasError() ? resp.getError() : null, resolveLockResult -> this.addResolvedLocks(version, resolveLockResult.getResolvedLocks()), version, forWrite);
            resp2 = this.callWithRetry(backOffer, TikvGrpc.getKvScanMethod(), request, handler);
            this.region = this.regionManager.getRegionByKey(startKey, backOffer);
        } while (!this.handleScanResponse(backOffer, resp2, version, forWrite));
        return resp2.getPairsList();
    }

    private boolean handleScanResponse(BackOffer backOffer, Kvrpcpb.ScanResponse resp, long version, boolean forWrite) {
        if (resp == null) {
            this.regionManager.onRequestFail(this.region);
            throw new TiClientInternalException("ScanResponse failed without a cause");
        }
        if (resp.hasRegionError()) {
            backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new RegionException(resp.getRegionError()));
            return false;
        }
        ArrayList<Lock> locks = new ArrayList<Lock>();
        for (Kvrpcpb.KvPair kvPair : resp.getPairsList()) {
            if (!kvPair.hasError()) continue;
            Lock lock = AbstractLockResolverClient.extractLockFromKeyErr(kvPair.getError(), this.codec);
            locks.add(lock);
        }
        if (!locks.isEmpty()) {
            ResolveLockResult resolveLockResult = this.lockResolverClient.resolveLocks(backOffer, version, locks, forWrite);
            this.addResolvedLocks(version, resolveLockResult.getResolvedLocks());
            long msBeforeExpired = resolveLockResult.getMsBeforeTxnExpired();
            if (msBeforeExpired > 0L) {
                backOffer.doBackOffWithMaxSleep(BackOffFunction.BackOffFuncType.BoTxnLockFast, msBeforeExpired, new KeyException(((Object)locks).toString()));
            }
            return false;
        }
        return true;
    }

    public List<Kvrpcpb.KvPair> scan(BackOffer backOffer, ByteString startKey, long version) {
        return this.scan(backOffer, startKey, version, false);
    }

    public void prewrite(BackOffer backOffer, ByteString primary, List<Kvrpcpb.Mutation> mutations, long startTs, long lockTTL) throws TiClientInternalException, KeyException, RegionException {
        this.prewrite(backOffer, primary, mutations, startTs, lockTTL, false);
    }

    public void prewrite(BackOffer bo, ByteString primaryLock, List<Kvrpcpb.Mutation> mutations, long startTs, long ttl, boolean skipConstraintCheck) throws TiClientInternalException, KeyException, RegionException {
        KVErrorHandler<Kvrpcpb.PrewriteResponse> handler;
        Supplier<Kvrpcpb.PrewriteRequest> factory;
        Kvrpcpb.PrewriteResponse resp2;
        boolean forWrite = true;
        do {
            factory = () -> this.getIsV4() != false ? Kvrpcpb.PrewriteRequest.newBuilder().setContext(this.makeContext(this.storeType, bo.getSlowLog())).setStartVersion(startTs).setPrimaryLock(this.codec.encodeKey(primaryLock)).addAllMutations(this.codec.encodeMutations(mutations)).setLockTtl(ttl).setSkipConstraintCheck(skipConstraintCheck).setMinCommitTs(startTs).setTxnSize(16L).build() : Kvrpcpb.PrewriteRequest.newBuilder().setContext(this.makeContext(this.storeType, bo.getSlowLog())).setStartVersion(startTs).setPrimaryLock(primaryLock).addAllMutations(mutations).setLockTtl(ttl).setSkipConstraintCheck(skipConstraintCheck).setTxnSize(16L).build();
            handler = new KVErrorHandler<Kvrpcpb.PrewriteResponse>(this.regionManager, this, this.lockResolverClient, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> null, resolveLockResult -> null, startTs, forWrite);
        } while (!this.isPrewriteSuccess(bo, resp2 = this.callWithRetry(bo, TikvGrpc.getKvPrewriteMethod(), factory, handler), startTs));
    }

    private boolean isPrewriteSuccess(BackOffer backOffer, Kvrpcpb.PrewriteResponse resp, long startTs) throws TiClientInternalException, KeyException, RegionException {
        boolean forWrite = true;
        if (resp == null) {
            this.regionManager.onRequestFail(this.region);
            throw new TiClientInternalException("Prewrite Response failed without a cause");
        }
        if (resp.hasRegionError()) {
            throw new RegionException(resp.getRegionError());
        }
        boolean isSuccess = true;
        ArrayList<Lock> locks = new ArrayList<Lock>();
        for (Kvrpcpb.KeyError err : resp.getErrorsList()) {
            if (err.hasLocked()) {
                isSuccess = false;
                Lock lock = new Lock(err.getLocked(), this.codec);
                locks.add(lock);
                continue;
            }
            throw new KeyException(err.toString());
        }
        if (isSuccess) {
            return true;
        }
        ResolveLockResult resolveLockResult = this.lockResolverClient.resolveLocks(backOffer, startTs, locks, forWrite);
        this.addResolvedLocks(startTs, resolveLockResult.getResolvedLocks());
        long msBeforeExpired = resolveLockResult.getMsBeforeTxnExpired();
        if (msBeforeExpired > 0L) {
            backOffer.doBackOffWithMaxSleep(BackOffFunction.BackOffFuncType.BoTxnLock, msBeforeExpired, new KeyException(resp.getErrorsList().get(0)));
        }
        return false;
    }

    public void txnHeartBeat(BackOffer bo, ByteString primaryLock, long startTs, long ttl) {
        KVErrorHandler<Kvrpcpb.TxnHeartBeatResponse> handler;
        Supplier<Kvrpcpb.TxnHeartBeatRequest> factory;
        Kvrpcpb.TxnHeartBeatResponse resp2;
        boolean forWrite = false;
        do {
            factory = () -> Kvrpcpb.TxnHeartBeatRequest.newBuilder().setContext(this.makeContext(this.storeType, bo.getSlowLog())).setStartVersion(startTs).setPrimaryLock(primaryLock).setAdviseLockTtl(ttl).build();
            handler = new KVErrorHandler<Kvrpcpb.TxnHeartBeatResponse>(this.regionManager, this, this.lockResolverClient, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> resp.hasError() ? resp.getError() : null, resolveLockResult -> null, startTs, forWrite);
        } while (!this.isTxnHeartBeatSuccess(resp2 = this.callWithRetry(bo, TikvGrpc.getKvTxnHeartBeatMethod(), factory, handler)));
    }

    private boolean isTxnHeartBeatSuccess(Kvrpcpb.TxnHeartBeatResponse resp) throws TiClientInternalException, RegionException {
        if (resp == null) {
            this.regionManager.onRequestFail(this.region);
            throw new TiClientInternalException("TxnHeartBeat Response failed without a cause");
        }
        if (resp.hasRegionError()) {
            throw new RegionException(resp.getRegionError());
        }
        if (resp.hasError()) {
            throw new TiClientInternalException("TxnHeartBeat fail, " + resp.getError().getAbort());
        }
        return true;
    }

    public void commit(BackOffer backOffer, Iterable<ByteString> keys, long startTs, long commitTs) throws KeyException {
        boolean forWrite = true;
        Supplier<Kvrpcpb.CommitRequest> factory = () -> Kvrpcpb.CommitRequest.newBuilder().setStartVersion(startTs).setCommitVersion(commitTs).addAllKeys(StreamSupport.stream(keys.spliterator(), false).map(this.codec::encodeKey).collect(Collectors.toList())).setContext(this.makeContext(this.storeType, backOffer.getSlowLog())).build();
        KVErrorHandler<Kvrpcpb.CommitResponse> handler = new KVErrorHandler<Kvrpcpb.CommitResponse>(this.regionManager, this, this.lockResolverClient, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> resp.hasError() ? resp.getError() : null, resolveLockResult -> null, startTs, forWrite);
        Kvrpcpb.CommitResponse resp2 = this.callWithRetry(backOffer, TikvGrpc.getKvCommitMethod(), factory, handler);
        this.handleCommitResponse(resp2);
    }

    private void handleCommitResponse(Kvrpcpb.CommitResponse resp) throws TiClientInternalException, RegionException, KeyException {
        if (resp == null) {
            this.regionManager.onRequestFail(this.region);
            throw new TiClientInternalException("CommitResponse failed without a cause");
        }
        if (resp.hasRegionError()) {
            throw new RegionException(resp.getRegionError());
        }
        if (resp.hasError()) {
            throw new KeyException(resp.getError());
        }
    }

    public List<RangeSplitter.RegionTask> coprocess(BackOffer backOffer, DAGRequest req, List<Coprocessor.KeyRange> ranges, Queue<SelectResponse> responseQueue, long startTs) {
        boolean forWrite = false;
        if (req == null || ranges == null || req.getExecutorsCount() < 1) {
            throw new IllegalArgumentException("Invalid coprocessor argument!");
        }
        Supplier<Coprocessor.Request> reqToSend = () -> Coprocessor.Request.newBuilder().setContext(this.makeContext(this.getResolvedLocks(startTs), this.storeType, backOffer.getSlowLog())).setTp(RequestTypes.REQ_TYPE_DAG.getValue()).setStartTs(startTs).setData(req.toByteString()).addAllRanges(ranges).build();
        KVErrorHandler<Coprocessor.Response> handler = new KVErrorHandler<Coprocessor.Response>(this.regionManager, this, this.lockResolverClient, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> null, resolveLockResult -> this.addResolvedLocks(startTs, resolveLockResult.getResolvedLocks()), startTs, forWrite);
        Coprocessor.Response resp2 = this.callWithRetry(backOffer, TikvGrpc.getCoprocessorMethod(), reqToSend, handler);
        return this.handleCopResponse(backOffer, resp2, ranges, responseQueue, startTs);
    }

    private List<RangeSplitter.RegionTask> handleCopResponse(BackOffer backOffer, Coprocessor.Response response, List<Coprocessor.KeyRange> ranges, Queue<SelectResponse> responseQueue, long startTs) {
        boolean forWrite = false;
        if (response == null) {
            backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new GrpcException("TiKV down or Network partition"));
            logger.warn("Re-splitting region task due to region error: TiKV down or Network partition");
            return RangeSplitter.newSplitter(this.regionManager).splitRangeByRegion(ranges, this.storeType);
        }
        if (response.hasRegionError()) {
            Errorpb.Error regionError = response.getRegionError();
            backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new GrpcException(regionError.toString()));
            logger.warn("Re-splitting region task due to region error:" + regionError.getMessage());
            return RangeSplitter.newSplitter(this.regionManager).splitRangeByRegion(ranges, this.storeType);
        }
        if (response.hasLocked()) {
            Lock lock = new Lock(response.getLocked(), this.codec);
            logger.debug(String.format("coprocessor encounters locks: %s", lock));
            ResolveLockResult resolveLockResult = this.lockResolverClient.resolveLocks(backOffer, startTs, Collections.singletonList(lock), forWrite);
            this.addResolvedLocks(startTs, resolveLockResult.getResolvedLocks());
            long msBeforeExpired = resolveLockResult.getMsBeforeTxnExpired();
            if (msBeforeExpired > 0L) {
                backOffer.doBackOffWithMaxSleep(BackOffFunction.BackOffFuncType.BoTxnLockFast, msBeforeExpired, new LockException(lock));
            }
            return RangeSplitter.newSplitter(this.regionManager).splitRangeByRegion(ranges, this.storeType);
        }
        String otherError = response.getOtherError();
        if (!otherError.isEmpty()) {
            logger.warn(String.format("Other error occurred, message: %s", otherError));
            throw new GrpcException(otherError);
        }
        responseQueue.offer(this.doCoprocessor(response));
        return null;
    }

    private Iterator<SelectResponse> doCoprocessor(StreamingResponse response) {
        final Iterator<Coprocessor.Response> responseIterator = response.iterator();
        if (!responseIterator.hasNext()) {
            return null;
        }
        return new Iterator<SelectResponse>(){

            @Override
            public boolean hasNext() {
                return responseIterator.hasNext();
            }

            @Override
            public SelectResponse next() {
                return RegionStoreClient.this.doCoprocessor((Coprocessor.Response)responseIterator.next());
            }
        };
    }

    private SelectResponse doCoprocessor(Coprocessor.Response resp) {
        try {
            SelectResponse selectResp = SelectResponse.parseFrom(resp.getData());
            if (selectResp.hasError()) {
                throw new SelectException(selectResp.getError(), selectResp.getError().getMsg());
            }
            return selectResp;
        }
        catch (InvalidProtocolBufferException e) {
            throw new TiClientInternalException("Error parsing protobuf for coprocessor response.", e);
        }
    }

    public Iterator<SelectResponse> coprocessStreaming(DAGRequest req, List<Coprocessor.KeyRange> ranges, long startTs) {
        boolean forWrite = false;
        Supplier<Coprocessor.Request> reqToSend = () -> Coprocessor.Request.newBuilder().setContext(this.makeContext(this.getResolvedLocks(startTs), this.storeType, SlowLogEmptyImpl.INSTANCE)).setTp(RequestTypes.REQ_TYPE_DAG.getValue()).setData(req.toByteString()).addAllRanges(ranges).build();
        KVErrorHandler<StreamingResponse> handler = new KVErrorHandler<StreamingResponse>(this.regionManager, this, this.lockResolverClient, StreamingResponse::getFirstRegionError, resp -> null, resolveLockResult -> this.addResolvedLocks(startTs, resolveLockResult.getResolvedLocks()), startTs, forWrite);
        StreamingResponse responseIterator = this.callServerStreamingWithRetry(ConcreteBackOffer.newCopNextMaxBackOff(this.pdClient.getClusterId()), TikvGrpc.getCoprocessorStreamMethod(), reqToSend, handler);
        return this.doCoprocessor(responseIterator);
    }

    public List<Metapb.Region> splitRegion(List<ByteString> splitKeys) {
        Supplier<Kvrpcpb.SplitRegionRequest> request = () -> Kvrpcpb.SplitRegionRequest.newBuilder().setContext(this.makeContext(this.storeType, SlowLogEmptyImpl.INSTANCE)).addAllSplitKeys(this.codec.encodeKeys(splitKeys)).setIsRawKv(this.conf.isRawKVMode()).build();
        KVErrorHandler<Kvrpcpb.SplitRegionResponse> handler = new KVErrorHandler<Kvrpcpb.SplitRegionResponse>(this.regionManager, this, null, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> null, resolveLockResult -> null, 0L, false);
        Kvrpcpb.SplitRegionResponse resp2 = this.callWithRetry(ConcreteBackOffer.newGetBackOff(this.pdClient.getClusterId()), TikvGrpc.getSplitRegionMethod(), request, handler);
        if (resp2 == null) {
            this.regionManager.onRequestFail(this.region);
            throw new TiClientInternalException("SplitRegion Response failed without a cause");
        }
        if (resp2.hasRegionError()) {
            throw new TiClientInternalException(String.format("failed to split region %d because %s", this.region.getId(), resp2.getRegionError()));
        }
        if (this.conf.getApiVersion().isV1()) {
            return resp2.getRegionsList();
        }
        return resp2.getRegionsList().stream().map(this.codec::decodeRegion).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<ByteString> rawGet(BackOffer backOffer, ByteString key) {
        Long clusterId = this.pdClient.getClusterId();
        Histogram.Timer requestTimer = ((Histogram.Child)GRPC_RAW_REQUEST_LATENCY.labels("client_grpc_raw_get", clusterId.toString())).startTimer();
        try {
            Supplier<Kvrpcpb.RawGetRequest> factory = () -> Kvrpcpb.RawGetRequest.newBuilder().setContext(this.makeContext(this.storeType, backOffer.getSlowLog())).setKey(this.codec.encodeKey(key)).build();
            RegionErrorHandler<Kvrpcpb.RawGetResponse> handler = new RegionErrorHandler<Kvrpcpb.RawGetResponse>(this.regionManager, this, resp -> resp.hasRegionError() ? resp.getRegionError() : null);
            Kvrpcpb.RawGetResponse resp2 = this.callWithRetry(backOffer, TikvGrpc.getRawGetMethod(), factory, handler);
            Optional<ByteString> optional = this.rawGetHelper(resp2);
            return optional;
        }
        finally {
            requestTimer.observeDuration();
        }
    }

    private Optional<ByteString> rawGetHelper(Kvrpcpb.RawGetResponse resp) {
        if (resp == null) {
            this.regionManager.onRequestFail(this.region);
            throw new TiClientInternalException("RawGetResponse failed without a cause");
        }
        String error = resp.getError();
        if (!error.isEmpty()) {
            throw new KeyException(resp.getError());
        }
        if (resp.hasRegionError()) {
            throw new RegionException(resp.getRegionError());
        }
        if (resp.getNotFound()) {
            return Optional.empty();
        }
        return Optional.of(resp.getValue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Long> rawGetKeyTTL(BackOffer backOffer, ByteString key) {
        Long clusterId = this.pdClient.getClusterId();
        Histogram.Timer requestTimer = ((Histogram.Child)GRPC_RAW_REQUEST_LATENCY.labels("client_grpc_raw_get_key_ttl", clusterId.toString())).startTimer();
        try {
            Supplier<Kvrpcpb.RawGetKeyTTLRequest> factory = () -> Kvrpcpb.RawGetKeyTTLRequest.newBuilder().setContext(this.makeContext(this.storeType, backOffer.getSlowLog())).setKey(this.codec.encodeKey(key)).build();
            RegionErrorHandler<Kvrpcpb.RawGetKeyTTLResponse> handler = new RegionErrorHandler<Kvrpcpb.RawGetKeyTTLResponse>(this.regionManager, this, resp -> resp.hasRegionError() ? resp.getRegionError() : null);
            Kvrpcpb.RawGetKeyTTLResponse resp2 = this.callWithRetry(backOffer, TikvGrpc.getRawGetKeyTTLMethod(), factory, handler);
            Optional<Long> optional = this.rawGetKeyTTLHelper(resp2);
            return optional;
        }
        finally {
            requestTimer.observeDuration();
        }
    }

    private Optional<Long> rawGetKeyTTLHelper(Kvrpcpb.RawGetKeyTTLResponse resp) {
        if (resp == null) {
            this.regionManager.onRequestFail(this.region);
            throw new TiClientInternalException("RawGetResponse failed without a cause");
        }
        String error = resp.getError();
        if (!error.isEmpty()) {
            throw new KeyException(resp.getError());
        }
        if (resp.hasRegionError()) {
            throw new RegionException(resp.getRegionError());
        }
        if (resp.getNotFound()) {
            return Optional.empty();
        }
        return Optional.of(resp.getTtl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rawDelete(BackOffer backOffer, ByteString key, boolean atomicForCAS) {
        Long clusterId = this.pdClient.getClusterId();
        Histogram.Timer requestTimer = ((Histogram.Child)GRPC_RAW_REQUEST_LATENCY.labels("client_grpc_raw_delete", clusterId.toString())).startTimer();
        try {
            Supplier<Kvrpcpb.RawDeleteRequest> factory = () -> Kvrpcpb.RawDeleteRequest.newBuilder().setContext(this.makeContext(this.storeType, backOffer.getSlowLog())).setKey(this.codec.encodeKey(key)).setForCas(atomicForCAS).build();
            RegionErrorHandler<Kvrpcpb.RawDeleteResponse> handler = new RegionErrorHandler<Kvrpcpb.RawDeleteResponse>(this.regionManager, this, resp -> resp.hasRegionError() ? resp.getRegionError() : null);
            Kvrpcpb.RawDeleteResponse resp2 = this.callWithRetry(backOffer, TikvGrpc.getRawDeleteMethod(), factory, handler);
            this.rawDeleteHelper(resp2, this.region);
        }
        finally {
            requestTimer.observeDuration();
        }
    }

    private void rawDeleteHelper(Kvrpcpb.RawDeleteResponse resp, TiRegion region) {
        if (resp == null) {
            this.regionManager.onRequestFail(region);
            throw new TiClientInternalException("RawDeleteResponse failed without a cause");
        }
        String error = resp.getError();
        if (!error.isEmpty()) {
            throw new KeyException(resp.getError());
        }
        if (resp.hasRegionError()) {
            throw new RegionException(resp.getRegionError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rawPut(BackOffer backOffer, ByteString key, ByteString value, long ttl, boolean atomicForCAS) {
        Long clusterId = this.pdClient.getClusterId();
        Histogram.Timer requestTimer = ((Histogram.Child)GRPC_RAW_REQUEST_LATENCY.labels("client_grpc_raw_put", clusterId.toString())).startTimer();
        try {
            Supplier<Kvrpcpb.RawPutRequest> factory = () -> Kvrpcpb.RawPutRequest.newBuilder().setContext(this.makeContext(this.storeType, backOffer.getSlowLog())).setKey(this.codec.encodeKey(key)).setValue(value).setTtl(ttl).setForCas(atomicForCAS).build();
            RegionErrorHandler<Kvrpcpb.RawPutResponse> handler = new RegionErrorHandler<Kvrpcpb.RawPutResponse>(this.regionManager, this, resp -> resp.hasRegionError() ? resp.getRegionError() : null);
            Kvrpcpb.RawPutResponse resp2 = this.callWithRetry(backOffer, TikvGrpc.getRawPutMethod(), factory, handler);
            this.rawPutHelper(resp2);
        }
        finally {
            requestTimer.observeDuration();
        }
    }

    private void rawPutHelper(Kvrpcpb.RawPutResponse resp) {
        if (resp == null) {
            this.regionManager.onRequestFail(this.region);
            throw new TiClientInternalException("RawPutResponse failed without a cause");
        }
        String error = resp.getError();
        if (!error.isEmpty()) {
            throw new KeyException(resp.getError());
        }
        if (resp.hasRegionError()) {
            throw new RegionException(resp.getRegionError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rawCompareAndSet(BackOffer backOffer, ByteString key, Optional<ByteString> prevValue, ByteString value, long ttl) throws RawCASConflictException {
        Long clusterId = this.pdClient.getClusterId();
        Histogram.Timer requestTimer = ((Histogram.Child)GRPC_RAW_REQUEST_LATENCY.labels("client_grpc_raw_put_if_absent", clusterId.toString())).startTimer();
        try {
            Supplier<Kvrpcpb.RawCASRequest> factory = () -> Kvrpcpb.RawCASRequest.newBuilder().setContext(this.makeContext(this.storeType, backOffer.getSlowLog())).setKey(this.codec.encodeKey(key)).setValue(value).setPreviousValue(prevValue.orElse(ByteString.EMPTY)).setPreviousNotExist(!prevValue.isPresent()).setTtl(ttl).build();
            RegionErrorHandler<Kvrpcpb.RawCASResponse> handler = new RegionErrorHandler<Kvrpcpb.RawCASResponse>(this.regionManager, this, resp -> resp.hasRegionError() ? resp.getRegionError() : null);
            Kvrpcpb.RawCASResponse resp2 = this.callWithRetry(backOffer, TikvGrpc.getRawCompareAndSwapMethod(), factory, handler);
            this.rawCompareAndSetHelper(key, prevValue, resp2);
        }
        finally {
            requestTimer.observeDuration();
        }
    }

    private void rawCompareAndSetHelper(ByteString key, Optional<ByteString> expectedPrevValue, Kvrpcpb.RawCASResponse resp) throws RawCASConflictException {
        if (resp == null) {
            this.regionManager.onRequestFail(this.region);
            throw new TiClientInternalException("RawCASResponse failed without a cause");
        }
        String error = resp.getError();
        if (!error.isEmpty()) {
            throw new KeyException(resp.getError());
        }
        if (resp.hasRegionError()) {
            throw new RegionException(resp.getRegionError());
        }
        if (!resp.getSucceed()) {
            if (resp.getPreviousNotExist()) {
                throw new RawCASConflictException(key, expectedPrevValue, Optional.empty());
            }
            throw new RawCASConflictException(key, expectedPrevValue, Optional.of(resp.getPreviousValue()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Kvrpcpb.KvPair> rawBatchGet(BackOffer backoffer, List<ByteString> keys) {
        Long clusterId = this.pdClient.getClusterId();
        Histogram.Timer requestTimer = ((Histogram.Child)GRPC_RAW_REQUEST_LATENCY.labels("client_grpc_raw_batch_get", clusterId.toString())).startTimer();
        try {
            if (keys.isEmpty()) {
                ArrayList<Kvrpcpb.KvPair> arrayList = new ArrayList<Kvrpcpb.KvPair>();
                return arrayList;
            }
            Supplier<Kvrpcpb.RawBatchGetRequest> factory = () -> Kvrpcpb.RawBatchGetRequest.newBuilder().setContext(this.makeContext(this.storeType, backoffer.getSlowLog())).addAllKeys(this.codec.encodeKeys(keys)).build();
            RegionErrorHandler<Kvrpcpb.RawBatchGetResponse> handler = new RegionErrorHandler<Kvrpcpb.RawBatchGetResponse>(this.regionManager, this, resp -> resp.hasRegionError() ? resp.getRegionError() : null);
            Kvrpcpb.RawBatchGetResponse resp2 = this.callWithRetry(backoffer, TikvGrpc.getRawBatchGetMethod(), factory, handler);
            List<Kvrpcpb.KvPair> list = this.handleRawBatchGet(resp2);
            return list;
        }
        finally {
            requestTimer.observeDuration();
        }
    }

    private List<Kvrpcpb.KvPair> handleRawBatchGet(Kvrpcpb.RawBatchGetResponse resp) {
        if (resp == null) {
            this.regionManager.onRequestFail(this.region);
            throw new TiClientInternalException("RawBatchPutResponse failed without a cause");
        }
        if (resp.hasRegionError()) {
            throw new RegionException(resp.getRegionError());
        }
        return this.codec.decodeKvPairs(resp.getPairsList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rawBatchPut(BackOffer backOffer, List<Kvrpcpb.KvPair> kvPairs, long ttl, boolean atomicForCAS) {
        Long clusterId = this.pdClient.getClusterId();
        Histogram.Timer requestTimer = ((Histogram.Child)GRPC_RAW_REQUEST_LATENCY.labels("client_grpc_raw_batch_put", clusterId.toString())).startTimer();
        try {
            if (kvPairs.isEmpty()) {
                return;
            }
            Supplier<Kvrpcpb.RawBatchPutRequest> factory = () -> Kvrpcpb.RawBatchPutRequest.newBuilder().setContext(this.makeContext(this.storeType, backOffer.getSlowLog())).addAllPairs(kvPairs).setTtl(ttl).addTtls(ttl).setForCas(atomicForCAS).build();
            RegionErrorHandler<Kvrpcpb.RawBatchPutResponse> handler = new RegionErrorHandler<Kvrpcpb.RawBatchPutResponse>(this.regionManager, this, resp -> resp.hasRegionError() ? resp.getRegionError() : null);
            Kvrpcpb.RawBatchPutResponse resp2 = this.callWithRetry(backOffer, TikvGrpc.getRawBatchPutMethod(), factory, handler);
            this.handleRawBatchPut(resp2);
        }
        finally {
            requestTimer.observeDuration();
        }
    }

    public void rawBatchPut(BackOffer backOffer, Batch batch, long ttl, boolean atomicForCAS) {
        ArrayList<Kvrpcpb.KvPair> pairs = new ArrayList<Kvrpcpb.KvPair>();
        for (int i = 0; i < batch.getKeys().size(); ++i) {
            pairs.add(Kvrpcpb.KvPair.newBuilder().setKey(this.codec.encodeKey(batch.getKeys().get(i))).setValue(batch.getValues().get(i)).build());
        }
        this.rawBatchPut(backOffer, pairs, ttl, atomicForCAS);
    }

    private void handleRawBatchPut(Kvrpcpb.RawBatchPutResponse resp) {
        if (resp == null) {
            this.regionManager.onRequestFail(this.region);
            throw new TiClientInternalException("RawBatchPutResponse failed without a cause");
        }
        String error = resp.getError();
        if (!error.isEmpty()) {
            throw new KeyException(resp.getError());
        }
        if (resp.hasRegionError()) {
            throw new RegionException(resp.getRegionError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rawBatchDelete(BackOffer backoffer, List<ByteString> keys, boolean atomicForCAS) {
        Long clusterId = this.pdClient.getClusterId();
        Histogram.Timer requestTimer = ((Histogram.Child)GRPC_RAW_REQUEST_LATENCY.labels("client_grpc_raw_batch_delete", clusterId.toString())).startTimer();
        try {
            if (keys.isEmpty()) {
                return;
            }
            Supplier<Kvrpcpb.RawBatchDeleteRequest> factory = () -> Kvrpcpb.RawBatchDeleteRequest.newBuilder().setContext(this.makeContext(this.storeType, backoffer.getSlowLog())).addAllKeys(this.codec.encodeKeys(keys)).setForCas(atomicForCAS).build();
            RegionErrorHandler<Kvrpcpb.RawBatchDeleteResponse> handler = new RegionErrorHandler<Kvrpcpb.RawBatchDeleteResponse>(this.regionManager, this, resp -> resp.hasRegionError() ? resp.getRegionError() : null);
            Kvrpcpb.RawBatchDeleteResponse resp2 = this.callWithRetry(backoffer, TikvGrpc.getRawBatchDeleteMethod(), factory, handler);
            this.handleRawBatchDelete(resp2);
        }
        finally {
            requestTimer.observeDuration();
        }
    }

    private void handleRawBatchDelete(Kvrpcpb.RawBatchDeleteResponse resp) {
        if (resp == null) {
            this.regionManager.onRequestFail(this.region);
            throw new TiClientInternalException("RawBatchDeleteResponse failed without a cause");
        }
        String error = resp.getError();
        if (!error.isEmpty()) {
            throw new KeyException(resp.getError());
        }
        if (resp.hasRegionError()) {
            throw new RegionException(resp.getRegionError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Kvrpcpb.KvPair> rawScan(BackOffer backOffer, ByteString key, int limit, boolean keyOnly) {
        Long clusterId = this.pdClient.getClusterId();
        Histogram.Timer requestTimer = ((Histogram.Child)GRPC_RAW_REQUEST_LATENCY.labels("client_grpc_raw_scan", clusterId.toString())).startTimer();
        try {
            Supplier<Kvrpcpb.RawScanRequest> factory = () -> {
                Pair<ByteString, ByteString> range = this.codec.encodeRange(key, ByteString.EMPTY);
                return Kvrpcpb.RawScanRequest.newBuilder().setContext(this.makeContext(this.storeType, backOffer.getSlowLog())).setStartKey((ByteString)range.first).setEndKey((ByteString)range.second).setKeyOnly(keyOnly).setLimit(limit).build();
            };
            RegionErrorHandler<Kvrpcpb.RawScanResponse> handler = new RegionErrorHandler<Kvrpcpb.RawScanResponse>(this.regionManager, this, resp -> resp.hasRegionError() ? resp.getRegionError() : null);
            Kvrpcpb.RawScanResponse resp2 = this.callWithRetry(backOffer, TikvGrpc.getRawScanMethod(), factory, handler);
            this.region = this.regionManager.getRegionByKey(key, backOffer);
            List<Kvrpcpb.KvPair> list = this.rawScanHelper(resp2);
            return list;
        }
        finally {
            requestTimer.observeDuration();
        }
    }

    public List<Kvrpcpb.KvPair> rawScan(BackOffer backOffer, ByteString key, boolean keyOnly) {
        return this.rawScan(backOffer, key, this.getConf().getScanBatchSize(), keyOnly);
    }

    private List<Kvrpcpb.KvPair> rawScanHelper(Kvrpcpb.RawScanResponse resp) {
        if (resp == null) {
            this.regionManager.onRequestFail(this.region);
            throw new TiClientInternalException("RawScanResponse failed without a cause");
        }
        if (resp.hasRegionError()) {
            throw new RegionException(resp.getRegionError());
        }
        return this.codec.decodeKvPairs(resp.getKvsList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rawDeleteRange(BackOffer backOffer, ByteString startKey, ByteString endKey) {
        Long clusterId = this.pdClient.getClusterId();
        Histogram.Timer requestTimer = ((Histogram.Child)GRPC_RAW_REQUEST_LATENCY.labels("client_grpc_raw_delete_range", clusterId.toString())).startTimer();
        try {
            Supplier<Kvrpcpb.RawDeleteRangeRequest> factory = () -> {
                Pair<ByteString, ByteString> range = this.codec.encodeRange(startKey, endKey);
                return Kvrpcpb.RawDeleteRangeRequest.newBuilder().setContext(this.makeContext(this.storeType, backOffer.getSlowLog())).setStartKey((ByteString)range.first).setEndKey((ByteString)range.second).build();
            };
            RegionErrorHandler<Kvrpcpb.RawDeleteRangeResponse> handler = new RegionErrorHandler<Kvrpcpb.RawDeleteRangeResponse>(this.regionManager, this, resp -> resp.hasRegionError() ? resp.getRegionError() : null);
            Kvrpcpb.RawDeleteRangeResponse resp2 = this.callWithRetry(backOffer, TikvGrpc.getRawDeleteRangeMethod(), factory, handler);
            this.rawDeleteRangeHelper(resp2);
        }
        finally {
            requestTimer.observeDuration();
        }
    }

    private void rawDeleteRangeHelper(Kvrpcpb.RawDeleteRangeResponse resp) {
        if (resp == null) {
            this.regionManager.onRequestFail(this.region);
            throw new TiClientInternalException("RawDeleteRangeResponse failed without a cause");
        }
        String error = resp.getError();
        if (!error.isEmpty()) {
            throw new KeyException(resp.getError());
        }
        if (resp.hasRegionError()) {
            throw new RegionException(resp.getRegionError());
        }
    }

    public static class RegionStoreClientBuilder {
        private final TiConfiguration conf;
        private final ChannelFactory channelFactory;
        private final RegionManager regionManager;
        private final PDClient pdClient;

        public RegionStoreClientBuilder(TiConfiguration conf, ChannelFactory channelFactory, RegionManager regionManager, PDClient pdClient) {
            Objects.requireNonNull(conf, "conf is null");
            Objects.requireNonNull(channelFactory, "channelFactory is null");
            Objects.requireNonNull(regionManager, "regionManager is null");
            this.conf = conf;
            this.channelFactory = channelFactory;
            this.regionManager = regionManager;
            this.pdClient = pdClient;
        }

        public RegionStoreClient build(TiRegion region, TiStore store, TiStoreType storeType) throws GrpcException {
            Objects.requireNonNull(region, "region is null");
            Objects.requireNonNull(store, "store is null");
            Objects.requireNonNull(storeType, "storeType is null");
            String addressStr = store.getStore().getAddress();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Create region store client on address %s", addressStr));
            }
            ManagedChannel channel = null;
            TikvGrpc.TikvBlockingStub blockingStub = null;
            TikvGrpc.TikvFutureStub asyncStub = null;
            if (this.conf.getEnableGrpcForward() && store.getProxyStore() != null && !store.isReachable()) {
                addressStr = store.getProxyStore().getAddress();
                channel = this.channelFactory.getChannel(addressStr, this.regionManager.getPDClient().getHostMapping());
                Metadata header = new Metadata();
                header.put(TiConfiguration.FORWARD_META_DATA_KEY, store.getStore().getAddress());
                blockingStub = MetadataUtils.attachHeaders(TikvGrpc.newBlockingStub(channel), header);
                asyncStub = MetadataUtils.attachHeaders(TikvGrpc.newFutureStub(channel), header);
            } else {
                channel = this.channelFactory.getChannel(addressStr, this.pdClient.getHostMapping());
                blockingStub = TikvGrpc.newBlockingStub(channel);
                asyncStub = TikvGrpc.newFutureStub(channel);
            }
            return new RegionStoreClient(this.conf, region, store, storeType, this.channelFactory, blockingStub, asyncStub, this.regionManager, this.pdClient, this);
        }

        public RegionStoreClient build(TiRegion region, TiStore store) throws GrpcException {
            return this.build(region, store, TiStoreType.TiKV);
        }

        public RegionStoreClient build(ByteString key) throws GrpcException {
            return this.build(key, TiStoreType.TiKV);
        }

        public RegionStoreClient build(ByteString key, BackOffer backOffer) throws GrpcException {
            return this.build(key, TiStoreType.TiKV, backOffer);
        }

        public RegionStoreClient build(ByteString key, TiStoreType storeType) throws GrpcException {
            return this.build(key, storeType, this.defaultBackOff());
        }

        public RegionStoreClient build(ByteString key, TiStoreType storeType, BackOffer backOffer) throws GrpcException {
            Pair<TiRegion, TiStore> pair = this.regionManager.getRegionStorePairByKey(key, storeType, backOffer);
            return this.build((TiRegion)pair.first, (TiStore)pair.second, storeType);
        }

        public RegionStoreClient build(TiRegion region) throws GrpcException {
            return this.build(region, this.defaultBackOff());
        }

        public RegionStoreClient build(TiRegion region, BackOffer backOffer) throws GrpcException {
            TiStore store = this.regionManager.getStoreById(region.getLeader().getStoreId(), backOffer);
            return this.build(region, store, TiStoreType.TiKV);
        }

        public RegionManager getRegionManager() {
            return this.regionManager;
        }

        private BackOffer defaultBackOff() {
            ConcreteBackOffer backoffer = ConcreteBackOffer.newCustomBackOff(this.conf.getRawKVDefaultBackoffInMS(), this.pdClient.getClusterId());
            return backoffer;
        }
    }

    public static enum RequestTypes {
        REQ_TYPE_SELECT(101),
        REQ_TYPE_INDEX(102),
        REQ_TYPE_DAG(103),
        REQ_TYPE_ANALYZE(104),
        BATCH_ROW_COUNT(64);

        private final int value;

        private RequestTypes(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

