/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.expression;

import java.io.Serializable;
import java.util.List;
import org.tikv.common.expression.Visitor;
import org.tikv.common.types.DataType;

public abstract class Expression
implements Serializable {
    protected DataType dataType;
    protected boolean resolved;

    public Expression(DataType dataType) {
        this.dataType = dataType;
        this.resolved = true;
    }

    public Expression() {
        this.resolved = false;
    }

    public abstract List<Expression> getChildren();

    public abstract <R, C> R accept(Visitor<R, C> var1, C var2);

    public boolean isResolved() {
        return this.getChildren().stream().allMatch(Expression::isResolved);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }
}

