/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.codec;

import java.util.Arrays;
import org.tikv.common.codec.CodecDataInputLittleEndian;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.codec.CodecDataOutputLittleEndian;
import org.tikv.common.exception.InvalidCodecFormatException;

public class RowV2 {
    public static int CODEC_VER = 128;
    boolean large;
    int numNotNullCols;
    int numNullCols;
    byte[] colIDs;
    int[] offsets;
    byte[] data;
    int[] colIDs32;
    int[] offsets32;

    private RowV2(byte[] rowData) {
        this.fromBytes(rowData);
    }

    public static RowV2 createNew(byte[] rowData) {
        return new RowV2(rowData);
    }

    public static RowV2 createEmpty() {
        return new RowV2(false, 0, 0);
    }

    private RowV2(boolean large, int numNotNullCols, int numNullCols) {
        this.large = large;
        this.numNotNullCols = numNotNullCols;
        this.numNullCols = numNullCols;
    }

    public byte[] getData(int i) {
        int start = 0;
        int end = 0;
        if (this.large) {
            if (i > 0) {
                start = this.offsets32[i - 1];
            }
            end = this.offsets32[i];
        } else {
            if (i > 0) {
                start = this.offsets[i - 1];
            }
            end = this.offsets[i];
        }
        return Arrays.copyOfRange(this.data, start, end);
    }

    private void fromBytes(byte[] rowData) {
        CodecDataInputLittleEndian cdi = new CodecDataInputLittleEndian(rowData);
        if (cdi.readUnsignedByte() != CODEC_VER) {
            throw new InvalidCodecFormatException("invalid codec version");
        }
        this.large = (cdi.readUnsignedByte() & 1) > 0;
        this.numNotNullCols = cdi.readUnsignedShort();
        this.numNullCols = cdi.readUnsignedShort();
        int cursor = 6;
        if (this.large) {
            int numCols = this.numNotNullCols + this.numNullCols;
            int colIDsLen = numCols * 4;
            this.colIDs32 = new int[numCols];
            for (int i = 0; i < numCols; ++i) {
                this.colIDs32[i] = cdi.readInt();
            }
            cursor += colIDsLen;
            numCols = this.numNotNullCols;
            int offsetsLen = numCols * 4;
            this.offsets32 = new int[numCols];
            for (int i = 0; i < numCols; ++i) {
                this.offsets32[i] = cdi.readInt();
            }
            cursor += offsetsLen;
        } else {
            int numCols;
            int colIDsLen = numCols = this.numNotNullCols + this.numNullCols;
            this.colIDs = new byte[numCols];
            cdi.readFully(this.colIDs, 0, numCols);
            cursor += colIDsLen;
            numCols = this.numNotNullCols;
            int offsetsLen = numCols * 2;
            this.offsets = new int[numCols];
            for (int i = 0; i < numCols; ++i) {
                this.offsets[i] = cdi.readUnsignedShort();
            }
            cursor += offsetsLen;
        }
        this.data = Arrays.copyOfRange(rowData, cursor, rowData.length);
    }

    private void writeShortArray(CodecDataOutput cdo, int[] arr) {
        for (int value : arr) {
            cdo.writeShort(value);
        }
    }

    private void writeIntArray(CodecDataOutput cdo, int[] arr) {
        for (int value : arr) {
            cdo.writeInt(value);
        }
    }

    public byte[] toBytes() {
        CodecDataOutputLittleEndian cdo = new CodecDataOutputLittleEndian();
        cdo.write(CODEC_VER);
        cdo.write(this.large ? 1 : 0);
        cdo.writeShort(this.numNotNullCols);
        cdo.writeShort(this.numNullCols);
        if (this.large) {
            this.writeIntArray(cdo, this.colIDs32);
            this.writeIntArray(cdo, this.offsets32);
        } else {
            cdo.write(this.colIDs);
            this.writeShortArray(cdo, this.offsets);
        }
        cdo.write(this.data);
        return cdo.toBytes();
    }

    private int binarySearch(int i, int j, long colID) {
        while (i < j) {
            int h = (int)((long)i + (long)j >> 1);
            long v = this.large ? (long)this.colIDs32[h] : (long)(this.colIDs[h] & 0xFF);
            if (v < colID) {
                i = h + 1;
                continue;
            }
            if (v > colID) {
                j = h;
                continue;
            }
            return h;
        }
        return -1;
    }

    public ColIDSearchResult findColID(long colID) {
        int i = 0;
        int j = this.numNotNullCols;
        ColIDSearchResult result = new ColIDSearchResult(-1, false, false);
        result.idx = this.binarySearch(i, j, colID);
        if (result.idx != -1) {
            return result;
        }
        i = this.numNotNullCols;
        j = this.numNotNullCols + this.numNullCols;
        int id = this.binarySearch(i, j, colID);
        if (id != -1) {
            result.isNull = true;
        } else {
            result.notFound = true;
        }
        return result;
    }

    public void initColIDs() {
        int numCols = this.numNotNullCols + this.numNullCols;
        this.colIDs = new byte[numCols];
    }

    public void initColIDs32() {
        int numCols = this.numNotNullCols + this.numNullCols;
        this.colIDs32 = new int[numCols];
    }

    public void initOffsets() {
        this.offsets = new int[this.numNotNullCols];
    }

    public void initOffsets32() {
        this.offsets32 = new int[this.numNotNullCols];
    }

    public static class ColIDSearchResult {
        int idx;
        boolean isNull;
        boolean notFound;

        private ColIDSearchResult(int idx, boolean isNull, boolean notFound) {
            this.idx = idx;
            this.isNull = isNull;
            this.notFound = notFound;
        }
    }
}

