/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.codec;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.tikv.common.ExtendedDateTime;
import org.tikv.common.codec.Codec;
import org.tikv.common.codec.CodecDataOutput;
import org.tikv.common.codec.CodecDataOutputLittleEndian;
import org.tikv.common.codec.MyDecimal;
import org.tikv.common.codec.RowV2;
import org.tikv.common.exception.CodecException;
import org.tikv.common.exception.TypeException;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.types.Converter;
import org.tikv.common.types.DataType;

public class RowEncoderV2 {
    private static final long SIGN_MASK = Long.MIN_VALUE;
    private int numCols;
    private Object[] values;
    private RowV2 row;

    public byte[] encode(List<TiColumnInfo> columnInfos, List<Object> values) {
        this.row = RowV2.createEmpty();
        this.numCols = columnInfos.size();
        for (int i = 0; i < this.numCols; ++i) {
            if (columnInfos.get(i).getId() > 255L) {
                this.row.large = true;
            }
            if (values.get(i) == null) {
                ++this.row.numNullCols;
                continue;
            }
            ++this.row.numNotNullCols;
        }
        this.values = new Object[this.numCols];
        this.reformatCols(columnInfos, values);
        this.encodeRowCols(columnInfos);
        return this.row.toBytes();
    }

    private void reformatCols(List<TiColumnInfo> columnInfos, List<Object> valueList) {
        block18: {
            int i;
            Integer[] idx;
            int len;
            block17: {
                int i2;
                int i3;
                int nullIdx = this.numCols - this.row.numNullCols;
                int notNullIdx = 0;
                if (this.row.large) {
                    this.row.initColIDs32();
                    this.row.initOffsets32();
                } else {
                    this.row.initColIDs();
                    this.row.initOffsets();
                }
                for (int i4 = 0; i4 < this.numCols; ++i4) {
                    int colID = (int)columnInfos.get(i4).getId();
                    Object value = valueList.get(i4);
                    if (value == null) {
                        if (this.row.large) {
                            this.row.colIDs32[nullIdx] = colID;
                        } else {
                            this.row.colIDs[nullIdx] = (byte)colID;
                        }
                        ++nullIdx;
                        continue;
                    }
                    if (this.row.large) {
                        this.row.colIDs32[notNullIdx] = colID;
                    } else {
                        this.row.colIDs[notNullIdx] = (byte)colID;
                    }
                    valueList.set(notNullIdx, value);
                    ++notNullIdx;
                }
                len = this.row.numNotNullCols;
                if (!this.row.large) break block17;
                int[] temp = Arrays.copyOfRange(this.row.colIDs32, 0, len);
                idx = new Integer[len];
                for (i3 = 0; i3 < len; ++i3) {
                    idx[i3] = i3;
                }
                Arrays.sort(idx, Comparator.comparingInt(o -> this.row.colIDs32[o]));
                for (i3 = 0; i3 < len; ++i3) {
                    this.row.colIDs32[i3] = temp[idx[i3]];
                    this.values[i3] = valueList.get(idx[i3]);
                }
                if (this.row.numNullCols <= 0) break block18;
                len = this.row.numNullCols;
                int start = this.row.numNotNullCols;
                temp = Arrays.copyOfRange(this.row.colIDs32, start, start + len);
                idx = new Integer[len];
                for (i2 = 0; i2 < len; ++i2) {
                    idx[i2] = i2;
                }
                Arrays.sort(idx, Comparator.comparingInt(o -> this.row.colIDs32[start + o]));
                for (i2 = 0; i2 < len; ++i2) {
                    this.row.colIDs32[start + i2] = temp[idx[i2]];
                }
                break block18;
            }
            byte[] temp = Arrays.copyOfRange(this.row.colIDs, 0, len);
            idx = new Integer[len];
            for (i = 0; i < len; ++i) {
                idx[i] = i;
            }
            Arrays.sort(idx, Comparator.comparingInt(o -> this.row.colIDs[o]));
            for (i = 0; i < len; ++i) {
                this.row.colIDs[i] = temp[idx[i]];
                this.values[i] = valueList.get(idx[i]);
            }
            if (this.row.numNullCols > 0) {
                int i5;
                len = this.row.numNullCols;
                int start = this.row.numNotNullCols;
                temp = Arrays.copyOfRange(this.row.colIDs, start, start + len);
                idx = new Integer[len];
                for (i5 = 0; i5 < len; ++i5) {
                    idx[i5] = i5;
                }
                Arrays.sort(idx, Comparator.comparingInt(o -> this.row.colIDs[start + o]));
                for (i5 = 0; i5 < len; ++i5) {
                    this.row.colIDs[start + i5] = temp[idx[i5]];
                }
            }
        }
    }

    private TiColumnInfo getColumnInfoByID(List<TiColumnInfo> columnInfos, int id) {
        for (TiColumnInfo columnInfo : columnInfos) {
            if (columnInfo.getId() != (long)id) continue;
            return columnInfo;
        }
        throw new CodecException("column id " + id + " not found in ColumnInfo");
    }

    private void encodeRowCols(List<TiColumnInfo> columnInfos) {
        CodecDataOutputLittleEndian cdo = new CodecDataOutputLittleEndian();
        for (int i = 0; i < this.row.numNotNullCols; ++i) {
            Object o = this.values[i];
            if (this.row.large) {
                this.encodeValue(cdo, o, this.getColumnInfoByID(columnInfos, this.row.colIDs32[i]).getType());
            } else {
                this.encodeValue(cdo, o, this.getColumnInfoByID(columnInfos, this.row.colIDs[i]).getType());
            }
            if (cdo.size() > 65535 && !this.row.large) {
                this.row.initColIDs32();
                for (int j = 0; j < this.numCols; ++j) {
                    this.row.colIDs32[j] = this.row.colIDs[j];
                }
                this.row.initOffsets32();
                if (this.numCols >= 0) {
                    System.arraycopy(this.row.offsets, 0, this.row.offsets32, 0, this.numCols);
                }
                this.row.large = true;
            }
            if (this.row.large) {
                this.row.offsets32[i] = cdo.size();
                continue;
            }
            this.row.offsets[i] = cdo.size();
        }
        this.row.data = cdo.toBytes();
    }

    private void encodeValue(CodecDataOutput cdo, Object value, DataType tp) {
        switch (tp.getType()) {
            case TypeLonglong: 
            case TypeLong: 
            case TypeInt24: 
            case TypeShort: 
            case TypeTiny: {
                this.encodeInt(cdo, (Long)value);
                break;
            }
            case TypeFloat: 
            case TypeDouble: {
                if (value instanceof Double) {
                    this.encodeDouble(cdo, value);
                    break;
                }
                if (value instanceof Float) {
                    this.encodeFloat(cdo, value);
                    break;
                }
                throw new TypeException("type does not match in encoding, should be float/double");
            }
            case TypeString: 
            case TypeVarString: 
            case TypeVarchar: 
            case TypeBlob: 
            case TypeTinyBlob: 
            case TypeMediumBlob: 
            case TypeLongBlob: {
                this.encodeString(cdo, value);
                break;
            }
            case TypeNewDecimal: {
                this.encodeDecimal(cdo, value);
                break;
            }
            case TypeBit: {
                this.encodeBit(cdo, value);
                break;
            }
            case TypeTimestamp: {
                this.encodeTimestamp(cdo, value, DateTimeZone.UTC);
                break;
            }
            case TypeDate: 
            case TypeDatetime: {
                this.encodeTimestamp(cdo, value, Converter.getLocalTimezone());
                break;
            }
            case TypeDuration: 
            case TypeYear: {
                this.encodeInt(cdo, (Long)value);
                break;
            }
            case TypeEnum: {
                this.encodeEnum(cdo, value, tp.getElems());
                break;
            }
            case TypeSet: {
                this.encodeSet(cdo, value, tp.getElems());
                break;
            }
            case TypeJSON: {
                this.encodeJson(cdo, value);
                break;
            }
            case TypeNull: 
            case TypeDecimal: 
            case TypeGeometry: 
            case TypeNewDate: {
                throw new CodecException("type should not appear in encoding");
            }
            default: {
                throw new CodecException("invalid data type: " + tp.getType().name());
            }
        }
    }

    private void encodeInt(CodecDataOutput cdo, long value) {
        if (value == (long)((byte)value)) {
            cdo.writeByte((byte)value);
        } else if (value == (long)((short)value)) {
            cdo.writeShort((short)value);
        } else if (value == (long)((int)value)) {
            cdo.writeInt((int)value);
        } else {
            cdo.writeLong(value);
        }
    }

    private void encodeFloat(CodecDataOutput cdo, Object value) {
        long u = Double.doubleToLongBits(((Float)value).floatValue());
        u = ((Float)value).floatValue() >= 0.0f ? (u |= Long.MIN_VALUE) : (u ^= 0xFFFFFFFFFFFFFFFFL);
        u = Long.reverseBytes(u);
        cdo.writeLong(u);
    }

    private void encodeDouble(CodecDataOutput cdo, Object value) {
        long u = Double.doubleToLongBits((Double)value);
        u = (Double)value >= 0.0 ? (u |= Long.MIN_VALUE) : (u ^= 0xFFFFFFFFFFFFFFFFL);
        u = Long.reverseBytes(u);
        cdo.writeLong(u);
    }

    private void encodeBit(CodecDataOutput cdo, Object value) {
        long s = 0L;
        if (value instanceof Long) {
            s = (Long)value;
        } else if (value instanceof byte[]) {
            for (byte b : (byte[])value) {
                s <<= 8;
                s |= (long)b;
            }
        } else {
            throw new CodecException("invalid bytes type " + value.getClass());
        }
        this.encodeInt(cdo, s);
    }

    private void encodeTimestamp(CodecDataOutput cdo, Object value, DateTimeZone tz) {
        if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            DateTime dateTime = new DateTime(timestamp.getTime());
            int nanos = timestamp.getNanos();
            ExtendedDateTime extendedDateTime = new ExtendedDateTime(dateTime, nanos / 1000 % 1000);
            long t = Codec.DateTimeCodec.toPackedLong(extendedDateTime, tz);
            this.encodeInt(cdo, t);
        } else if (value instanceof Date) {
            ExtendedDateTime extendedDateTime = new ExtendedDateTime(new DateTime(((Date)value).getTime()));
            long t = Codec.DateTimeCodec.toPackedLong(extendedDateTime, tz);
            this.encodeInt(cdo, t);
        } else {
            throw new CodecException("invalid timestamp type " + value.getClass());
        }
    }

    private void encodeString(CodecDataOutput cdo, Object value) {
        if (value instanceof byte[]) {
            cdo.write((byte[])value);
        } else if (value instanceof String) {
            cdo.write(((String)value).getBytes(StandardCharsets.UTF_8));
        } else {
            throw new CodecException("invalid string type " + value.getClass());
        }
    }

    private void encodeDecimal(CodecDataOutput cdo, Object value) {
        if (value instanceof MyDecimal) {
            MyDecimal dec = (MyDecimal)value;
            Codec.DecimalCodec.writeDecimal(cdo, dec, dec.precision(), dec.frac());
        } else if (value instanceof BigDecimal) {
            MyDecimal dec = new MyDecimal();
            BigDecimal decimal = (BigDecimal)value;
            int prec = decimal.precision();
            int frac = decimal.scale();
            dec.fromString(((BigDecimal)value).toPlainString());
            Codec.DecimalCodec.writeDecimal(cdo, dec, prec, frac);
        } else {
            throw new CodecException("invalid decimal type " + value.getClass());
        }
    }

    private void encodeEnum(CodecDataOutput cdo, Object value, List<String> elems) {
        if (value instanceof Integer) {
            this.encodeInt(cdo, ((Integer)value).intValue());
        } else if (value instanceof String) {
            int val = Codec.EnumCodec.parseEnumName((String)value, elems);
            this.encodeInt(cdo, val);
        } else {
            throw new CodecException("invalid enum type " + value.getClass());
        }
    }

    private void encodeSet(CodecDataOutput cdo, Object value, List<String> elems) {
        throw new CodecException("Set encoding is not yet supported.");
    }

    private void encodeJson(CodecDataOutput cdo, Object value) {
        throw new CodecException("JSON encoding is not yet supported.");
    }
}

