/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.HostMapping;
import org.tikv.common.TiConfiguration;
import org.tikv.common.operation.ErrorHandler;
import org.tikv.common.policy.RetryMaxMs;
import org.tikv.common.policy.RetryPolicy;
import org.tikv.common.streaming.StreamingResponse;
import org.tikv.common.util.BackOffFunction;
import org.tikv.common.util.BackOffer;
import org.tikv.common.util.ChannelFactory;
import org.tikv.shade.io.grpc.ManagedChannel;
import org.tikv.shade.io.grpc.MethodDescriptor;
import org.tikv.shade.io.grpc.health.v1.HealthCheckRequest;
import org.tikv.shade.io.grpc.health.v1.HealthCheckResponse;
import org.tikv.shade.io.grpc.health.v1.HealthGrpc;
import org.tikv.shade.io.grpc.stub.AbstractFutureStub;
import org.tikv.shade.io.grpc.stub.AbstractStub;
import org.tikv.shade.io.grpc.stub.ClientCalls;
import org.tikv.shade.io.grpc.stub.StreamObserver;

public abstract class AbstractGRPCClient<BlockingStubT extends AbstractStub<BlockingStubT>, FutureStubT extends AbstractFutureStub<FutureStubT>>
implements AutoCloseable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ChannelFactory channelFactory;
    protected TiConfiguration conf;
    protected long timeout;
    protected BlockingStubT blockingStub;
    protected FutureStubT asyncStub;

    protected AbstractGRPCClient(TiConfiguration conf, ChannelFactory channelFactory) {
        this.conf = conf;
        this.timeout = conf.getTimeout();
        this.channelFactory = channelFactory;
    }

    protected AbstractGRPCClient(TiConfiguration conf, ChannelFactory channelFactory, BlockingStubT blockingStub, FutureStubT asyncStub) {
        this.conf = conf;
        this.timeout = conf.getTimeout();
        this.channelFactory = channelFactory;
        this.blockingStub = blockingStub;
        this.asyncStub = asyncStub;
    }

    public TiConfiguration getConf() {
        return this.conf;
    }

    public <ReqT, RespT> RespT callWithRetry(BackOffer backOffer, MethodDescriptor<ReqT, RespT> method, Supplier<ReqT> requestFactory, ErrorHandler<RespT> handler) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("Calling %s...", method.getFullMethodName()));
        }
        RetryPolicy policy = new RetryMaxMs.Builder<RespT>(backOffer).create(handler);
        Object resp = policy.callWithRetry(() -> {
            BlockingStubT stub = this.getBlockingStub();
            return ClientCalls.blockingUnaryCall(((AbstractStub)stub).getChannel(), method, ((AbstractStub)stub).getCallOptions(), requestFactory.get());
        }, method.getFullMethodName(), backOffer);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace(String.format("leaving %s...", method.getFullMethodName()));
        }
        return (RespT)resp;
    }

    protected <ReqT, RespT> void callAsyncWithRetry(BackOffer backOffer, MethodDescriptor<ReqT, RespT> method, Supplier<ReqT> requestFactory, StreamObserver<RespT> responseObserver, ErrorHandler<RespT> handler) {
        this.logger.debug(String.format("Calling %s...", method.getFullMethodName()));
        RetryPolicy policy = new RetryMaxMs.Builder<RespT>(backOffer).create(handler);
        policy.callWithRetry(() -> {
            FutureStubT stub = this.getAsyncStub();
            ClientCalls.asyncUnaryCall(((AbstractStub)stub).getChannel().newCall(method, ((AbstractStub)stub).getCallOptions()), requestFactory.get(), responseObserver);
            return null;
        }, method.getFullMethodName(), backOffer);
        this.logger.debug(String.format("leaving %s...", method.getFullMethodName()));
    }

    <ReqT, RespT> StreamObserver<ReqT> callBidiStreamingWithRetry(BackOffer backOffer, MethodDescriptor<ReqT, RespT> method, StreamObserver<RespT> responseObserver, ErrorHandler<StreamObserver<ReqT>> handler) {
        this.logger.debug(String.format("Calling %s...", method.getFullMethodName()));
        RetryPolicy<StreamObserver<ReqT>> policy = new RetryMaxMs.Builder<StreamObserver<ReqT>>(backOffer).create(handler);
        StreamObserver observer = policy.callWithRetry(() -> {
            FutureStubT stub = this.getAsyncStub();
            return ClientCalls.asyncBidiStreamingCall(((AbstractStub)stub).getChannel().newCall(method, ((AbstractStub)stub).getCallOptions()), responseObserver);
        }, method.getFullMethodName(), backOffer);
        this.logger.debug(String.format("leaving %s...", method.getFullMethodName()));
        return observer;
    }

    public <ReqT, RespT> StreamingResponse callServerStreamingWithRetry(BackOffer backOffer, MethodDescriptor<ReqT, RespT> method, Supplier<ReqT> requestFactory, ErrorHandler<StreamingResponse> handler) {
        this.logger.debug(String.format("Calling %s...", method.getFullMethodName()));
        RetryPolicy<StreamingResponse> policy = new RetryMaxMs.Builder<StreamingResponse>(backOffer).create(handler);
        StreamingResponse response = policy.callWithRetry(() -> {
            BlockingStubT stub = this.getBlockingStub();
            return new StreamingResponse(ClientCalls.blockingServerStreamingCall(((AbstractStub)stub).getChannel(), method, ((AbstractStub)stub).getCallOptions(), requestFactory.get()));
        }, method.getFullMethodName(), backOffer);
        this.logger.debug(String.format("leaving %s...", method.getFullMethodName()));
        return response;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }

    protected abstract BlockingStubT getBlockingStub();

    protected abstract FutureStubT getAsyncStub();

    private boolean doCheckHealth(BackOffer backOffer, String addressStr, HostMapping hostMapping) {
        while (true) {
            backOffer.checkTimeout();
            try {
                ManagedChannel channel = this.channelFactory.getChannel(addressStr, hostMapping);
                HealthGrpc.HealthBlockingStub stub = (HealthGrpc.HealthBlockingStub)HealthGrpc.newBlockingStub(channel).withDeadlineAfter(this.getTimeout(), TimeUnit.MILLISECONDS);
                HealthCheckRequest req = HealthCheckRequest.newBuilder().build();
                HealthCheckResponse resp = stub.check(req);
                return resp.getStatus() == HealthCheckResponse.ServingStatus.SERVING;
            }
            catch (Exception e) {
                this.logger.warn("check health failed, addr: {}, caused by: {}", (Object)addressStr, (Object)e.getMessage());
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoCheckHealth, e);
                continue;
            }
            break;
        }
    }

    protected boolean checkHealth(BackOffer backOffer, String addressStr, HostMapping hostMapping) {
        try {
            return this.doCheckHealth(backOffer, addressStr, hostMapping);
        }
        catch (Exception e) {
            return false;
        }
    }
}

