/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.joda.convert.RenameHandler;
import org.tikv.shade.com.google.common.collect.ImmutableMap;

abstract class AbstractTypeStringConverter {
    private static final String EXTENDS = "? extends ";
    private static final String SUPER = "? super ";
    private static final ImmutableMap<String, Class<?>> PRIMITIVES = ImmutableMap.builder().put("byte", Byte.TYPE).put("short", Short.TYPE).put("int", Integer.TYPE).put("long", Long.TYPE).put("boolean", Boolean.TYPE).put("char", Character.TYPE).put("float", Float.TYPE).put("double", Double.TYPE).build();
    private static final Method NEW_PARAM_TYPE;
    private static final Method EXTENDS_TYPE;
    private static final Method SUPER_TYPE;

    AbstractTypeStringConverter() {
    }

    static Type parse(String str) {
        try {
            return AbstractTypeStringConverter.doParse(str);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static Type doParse(String str) throws Exception {
        Class<?> token = PRIMITIVES.get(str);
        if (token != null) {
            return token;
        }
        int first = str.indexOf(60);
        if (first < 0) {
            return RenameHandler.INSTANCE.loadType(str);
        }
        int last = str.lastIndexOf(62);
        String baseStr = str.substring(0, first);
        Class<?> base = RenameHandler.INSTANCE.loadType(baseStr);
        String argsStr = str.substring(first + 1, last);
        List<String> splitArgs = AbstractTypeStringConverter.split(argsStr);
        ArrayList types = new ArrayList();
        for (String splitArg : splitArgs) {
            Class<?> componentCls;
            String componentStr;
            Class<?> argType;
            String remainder;
            if (splitArg.startsWith(EXTENDS)) {
                remainder = splitArg.substring(EXTENDS.length());
                argType = AbstractTypeStringConverter.wildExtendsType(AbstractTypeStringConverter.doParse(remainder));
            } else if (splitArg.startsWith(SUPER)) {
                remainder = splitArg.substring(SUPER.length());
                argType = AbstractTypeStringConverter.wildSuperType(AbstractTypeStringConverter.doParse(remainder));
            } else if (splitArg.equals("?")) {
                argType = AbstractTypeStringConverter.wildExtendsType(Object.class);
            } else if (splitArg.endsWith("[]")) {
                componentStr = splitArg.substring(0, splitArg.length() - 2);
                componentCls = RenameHandler.INSTANCE.loadType(componentStr);
                argType = Array.newInstance(componentCls, 0).getClass();
            } else if (splitArg.startsWith("[L") && splitArg.endsWith(";")) {
                componentStr = splitArg.substring(2, splitArg.length() - 1);
                componentCls = RenameHandler.INSTANCE.loadType(componentStr);
                argType = Array.newInstance(componentCls, 0).getClass();
            } else {
                argType = AbstractTypeStringConverter.doParse(splitArg);
            }
            types.add(argType);
        }
        return AbstractTypeStringConverter.newParameterizedType(base, types.toArray(new Type[types.size()]));
    }

    private static List<String> split(String str) {
        ArrayList<String> result = new ArrayList<String>();
        int genericCount = 0;
        int startPos = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == ',' && genericCount == 0) {
                result.add(str.substring(startPos, i).trim());
                startPos = i + 1;
                continue;
            }
            if (str.charAt(i) == '<') {
                ++genericCount;
                continue;
            }
            if (str.charAt(i) != '>') continue;
            --genericCount;
        }
        result.add(str.substring(startPos).trim());
        return result;
    }

    private static Type wildExtendsType(Type bound) throws Exception {
        return (Type)EXTENDS_TYPE.invoke(null, bound);
    }

    private static Type wildSuperType(Type bound) throws Exception {
        return (Type)SUPER_TYPE.invoke(null, bound);
    }

    private static ParameterizedType newParameterizedType(Class<?> base, Type ... args) throws Exception {
        return (ParameterizedType)NEW_PARAM_TYPE.invoke(null, base, args);
    }

    static {
        try {
            Class<?> typesClass = RenameHandler.INSTANCE.loadType("org.tikv.shade.com.google.common.reflect.Types");
            Method newParam = typesClass.getDeclaredMethod("newParameterizedType", Class.class, Type[].class);
            newParam.setAccessible(true);
            NEW_PARAM_TYPE = newParam;
            Method extendsType = typesClass.getDeclaredMethod("subtypeOf", Type.class);
            extendsType.setAccessible(true);
            EXTENDS_TYPE = extendsType;
            Method superType = typesClass.getDeclaredMethod("supertypeOf", Type.class);
            superType.setAccessible(true);
            SUPER_TYPE = superType;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

