/*
 * Copyright 2020 TiKV Project Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.tikv.txn.exception;

import org.tikv.common.codec.KeyUtils;

public class WriteConflictException extends RuntimeException {
  public WriteConflictException(long callerStartTS, long txnID, long commitTS, byte[] key) {
    super(
        String.format(
            "callerStartTS=%d txnID=%d commitTS=%d key=%s",
            callerStartTS, txnID, commitTS, KeyUtils.formatBytes(key)));
  }
}
