/*
 * Copyright 2021 TiKV Project Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.tikv.common.columnar.datatypes;

import org.tikv.common.types.DataType;
import org.tikv.common.types.DecimalType;

public class CHTypeDecimal extends CHType {
  public int precision, scale;

  public CHTypeDecimal(int precision, int scale) {
    this.precision = precision;
    this.scale = scale;
    if (precision <= 9) {
      length = 4;
    } else if (precision <= 18) {
      length = 8;
    } else if (precision <= 38) {
      length = 16;
    } else {
      length = 48;
    }
  }

  @Override
  public String name() {
    return "Decimal(" + precision + ", " + scale + ")";
  }

  @Override
  public DataType toDataType() {
    return new DecimalType(precision, scale);
  }
}
