/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.predicates;

import com.pingcap.tidb.tipb.EncodeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.common.exception.TiClientInternalException;
import org.tikv.common.expression.Expression;
import org.tikv.common.expression.PartitionPruner;
import org.tikv.common.expression.visitor.IndexMatcher;
import org.tikv.common.key.IndexScanKeyRangeBuilder;
import org.tikv.common.key.Key;
import org.tikv.common.key.RowKey;
import org.tikv.common.key.TypedKey;
import org.tikv.common.meta.TiColumnInfo;
import org.tikv.common.meta.TiDAGRequest;
import org.tikv.common.meta.TiIndexColumn;
import org.tikv.common.meta.TiIndexInfo;
import org.tikv.common.meta.TiPartitionDef;
import org.tikv.common.meta.TiTableInfo;
import org.tikv.common.meta.TiTimestamp;
import org.tikv.common.predicates.IndexRange;
import org.tikv.common.predicates.PredicateUtils;
import org.tikv.common.predicates.ScanSpec;
import org.tikv.common.predicates.SelectivityCalculator;
import org.tikv.common.region.TiStoreType;
import org.tikv.common.statistics.IndexStatistics;
import org.tikv.common.statistics.TableStatistics;
import org.tikv.common.util.KeyRangeUtils;
import org.tikv.common.util.Pair;
import org.tikv.kvproto.Coprocessor;
import org.tikv.shade.com.google.common.annotations.VisibleForTesting;
import org.tikv.shade.com.google.common.base.Preconditions;
import org.tikv.shade.com.google.common.collect.BoundType;
import org.tikv.shade.com.google.common.collect.ImmutableList;
import org.tikv.shade.com.google.common.collect.Range;

public class TiKVScanAnalyzer {
    private static final double INDEX_SCAN_COST_FACTOR = 1.2;
    private static final double TABLE_SCAN_COST_FACTOR = 1.0;
    private static final double DOUBLE_READ_COST_FACTOR = 3.0;
    private static final long TABLE_PREFIX_SIZE = 8L;
    private static final long INDEX_PREFIX_SIZE = 8L;

    @VisibleForTesting
    public static ScanSpec extractConditions(List<Expression> conditions, TiTableInfo table, TiIndexInfo index) {
        ScanSpec.Builder specBuilder = new ScanSpec.Builder(table, index);
        if (index != null) {
            HashSet<Expression> visited = new HashSet<Expression>();
            block0: for (int i = 0; i < index.getIndexColumns().size(); ++i) {
                TiIndexColumn col = index.getIndexColumns().get(i);
                IndexMatcher eqMatcher = IndexMatcher.equalOnlyMatcher(col);
                boolean found = false;
                for (Expression cond : conditions) {
                    if (visited.contains(cond) || !eqMatcher.match(cond)) continue;
                    specBuilder.addPointPredicate(col, cond);
                    if (col.isPrefixIndex()) {
                        specBuilder.addResidualPredicate(cond);
                        break block0;
                    }
                    visited.add(cond);
                    found = true;
                    break;
                }
                if (found) continue;
                IndexMatcher matcher = IndexMatcher.matcher(col);
                for (Expression cond : conditions) {
                    if (visited.contains(cond) || !matcher.match(cond)) continue;
                    specBuilder.addRangePredicate(col, cond);
                    if (!col.isPrefixIndex()) continue;
                    specBuilder.addResidualPredicate(cond);
                    break block0;
                }
                break;
            }
        }
        specBuilder.addAllPredicates(conditions);
        return specBuilder.build();
    }

    public TiDAGRequest buildTiDAGReq(List<TiColumnInfo> columnList, List<Expression> conditions, TiTableInfo table, TiTimestamp ts, TiDAGRequest dagRequest) {
        return this.buildTiDAGReq(true, true, false, columnList, conditions, table, null, ts, dagRequest);
    }

    public TiDAGRequest buildTiDAGReq(boolean allowIndexScan, boolean canUseTiKV, boolean canUseTiFlash, List<TiColumnInfo> columnList, List<Expression> conditions, TiTableInfo table, TableStatistics tableStatistics, TiTimestamp ts, TiDAGRequest dagRequest) {
        TiKVScanPlan minPlan = null;
        if (canUseTiKV) {
            minPlan = this.buildTableScan(conditions, table, tableStatistics);
        }
        if (canUseTiFlash) {
            TiKVScanPlan plan = this.buildTiFlashScan(columnList, conditions, table, tableStatistics);
            if (minPlan == null || plan.getCost() < minPlan.getCost()) {
                minPlan = plan;
            }
        } else if (canUseTiKV && allowIndexScan) {
            minPlan.getFilters().forEach(dagRequest::addDowngradeFilter);
            double minCost = minPlan.getCost();
            for (TiIndexInfo index : table.getIndices()) {
                TiKVScanPlan plan = this.buildIndexScan(columnList, conditions, index, table, tableStatistics, false);
                if (!(plan.getCost() < minCost)) continue;
                minPlan = plan;
                minCost = plan.getCost();
            }
        }
        if (minPlan == null) {
            throw new TiClientInternalException("No valid plan found for table '" + table.getName() + "'");
        }
        TiStoreType minPlanStoreType = minPlan.getStoreType();
        if (minPlanStoreType == TiStoreType.TiKV && dagRequest.getEncodeType() == EncodeType.TypeCHBlock) {
            dagRequest.setEncodeType(EncodeType.TypeChunk);
        }
        dagRequest.setStoreType(minPlanStoreType);
        dagRequest.addRanges(minPlan.getKeyRanges());
        dagRequest.setPrunedParts(minPlan.getPrunedParts());
        dagRequest.addFilters(new ArrayList<Expression>(minPlan.getFilters()));
        if (minPlan.isIndexScan()) {
            dagRequest.setIndexInfo(minPlan.getIndex());
            dagRequest.setIsDoubleRead(minPlan.isDoubleRead());
        }
        dagRequest.setTableInfo(table);
        dagRequest.setStartTs(ts);
        dagRequest.setEstimatedCount(minPlan.getEstimatedRowCount());
        return dagRequest;
    }

    private TiKVScanPlan buildTableScan(List<Expression> conditions, TiTableInfo table, TableStatistics tableStatistics) {
        TiIndexInfo pkIndex = TiIndexInfo.generateFakePrimaryKeyIndex(table);
        return this.buildIndexScan(table.getColumns(), conditions, pkIndex, table, tableStatistics, false);
    }

    private TiKVScanPlan buildTiFlashScan(List<TiColumnInfo> columnList, List<Expression> conditions, TiTableInfo table, TableStatistics tableStatistics) {
        TiIndexInfo pkIndex = TiIndexInfo.generateFakePrimaryKeyIndex(table);
        return this.buildIndexScan(columnList, conditions, pkIndex, table, tableStatistics, true);
    }

    TiKVScanPlan buildIndexScan(List<TiColumnInfo> columnList, List<Expression> conditions, TiIndexInfo index, TiTableInfo table, TableStatistics tableStatistics, boolean useTiFlash) {
        Objects.requireNonNull(table, "Table cannot be null to encoding keyRange");
        Objects.requireNonNull(conditions, "conditions cannot be null to encoding keyRange");
        TiKVScanPlan.Builder planBuilder = TiKVScanPlan.Builder.newBuilder(table.getName());
        ScanSpec result = TiKVScanAnalyzer.extractConditions(conditions, table, index);
        double cost = SelectivityCalculator.calcPseudoSelectivity(result);
        planBuilder.setCost(cost);
        List<IndexRange> irs = PredicateUtils.expressionToIndexRanges(result.getPointPredicates(), result.getRangePredicate(), table, index);
        List<TiPartitionDef> prunedParts = null;
        if (table.getPartitionInfo() != null) {
            prunedParts = PartitionPruner.prune(table, conditions);
        }
        planBuilder.setFilters(result.getResidualPredicates()).setPrunedParts(prunedParts);
        long tableColSize = table.getEstimatedRowSizeInByte() + 8L;
        if (index == null || index.isFakePrimaryKey()) {
            planBuilder.setDoubleRead(false).setKeyRanges(this.buildTableScanKeyRange(table, irs, prunedParts));
            if (useTiFlash) {
                long colSize = columnList.stream().mapToLong(TiColumnInfo::getSize).sum() + 8L;
                return planBuilder.setStoreType(TiStoreType.TiFlash).calculateCostAndEstimateCount(tableStatistics, colSize).build();
            }
            return planBuilder.calculateCostAndEstimateCount(tableStatistics, tableColSize).build();
        }
        assert (!useTiFlash);
        long indexSize = index.getIndexColumnSize() + 8L + 8L;
        return planBuilder.setIndex(index).setDoubleRead(!this.isCoveringIndex(columnList, index, table.isPkHandle())).calculateCostAndEstimateCount(tableStatistics, conditions, irs, indexSize, tableColSize).setKeyRanges(this.buildIndexScanKeyRange(table, index, irs, prunedParts)).build();
    }

    private Pair<Key, Key> buildTableScanKeyRangePerId(long id, IndexRange ir) {
        Key endKey;
        Key startKey;
        if (ir.hasAccessKey()) {
            Preconditions.checkArgument(!ir.hasRange(), "Table scan must have one and only one access condition / point");
            Key key = ir.getAccessKey();
            Preconditions.checkArgument(key instanceof TypedKey, "Table scan key range must be typed key");
            TypedKey typedKey = (TypedKey)key;
            startKey = RowKey.toRowKey(id, typedKey);
            endKey = ((Key)startKey).next();
        } else if (ir.hasRange()) {
            Preconditions.checkArgument(!ir.hasAccessKey(), "Table scan must have one and only one access condition / point");
            Range<TypedKey> r = ir.getRange();
            if (!r.hasLowerBound()) {
                startKey = RowKey.createMin(id);
            } else {
                startKey = RowKey.toRowKey(id, r.lowerEndpoint());
                if (r.lowerBoundType().equals((Object)BoundType.OPEN)) {
                    startKey = ((Key)startKey).next();
                }
            }
            if (!r.hasUpperBound()) {
                endKey = RowKey.createBeyondMax(id);
            } else {
                endKey = RowKey.toRowKey(id, r.upperEndpoint());
                if (r.upperBoundType().equals((Object)BoundType.CLOSED)) {
                    endKey = endKey.next();
                }
            }
        } else {
            throw new TiClientInternalException("Empty access conditions");
        }
        return new Pair<Key, Key>(startKey, endKey);
    }

    private Map<Long, List<Coprocessor.KeyRange>> buildTableScanKeyRangeWithIds(List<Long> ids, List<IndexRange> indexRanges) {
        HashMap<Long, List<Coprocessor.KeyRange>> idRanges = new HashMap<Long, List<Coprocessor.KeyRange>>(ids.size());
        for (Long id : ids) {
            ArrayList ranges = new ArrayList(indexRanges.size());
            indexRanges.forEach(ir -> {
                Pair<Key, Key> pairKey = this.buildTableScanKeyRangePerId(id, (IndexRange)ir);
                Key startKey = (Key)pairKey.first;
                Key endKey = (Key)pairKey.second;
                if (!startKey.equals(endKey)) {
                    ranges.add(KeyRangeUtils.makeCoprocRange(startKey.toByteString(), endKey.toByteString()));
                }
            });
            idRanges.put(id, ranges);
        }
        return idRanges;
    }

    @VisibleForTesting
    Map<Long, List<Coprocessor.KeyRange>> buildTableScanKeyRange(TiTableInfo table, List<IndexRange> indexRanges, List<TiPartitionDef> prunedParts) {
        Objects.requireNonNull(table, "Table is null");
        Objects.requireNonNull(indexRanges, "indexRanges is null");
        if (table.isPartitionEnabled()) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (TiPartitionDef pDef : prunedParts) {
                ids.add(pDef.getId());
            }
            return this.buildTableScanKeyRangeWithIds(ids, indexRanges);
        }
        return this.buildTableScanKeyRangeWithIds(ImmutableList.of(Long.valueOf(table.getId())), indexRanges);
    }

    @VisibleForTesting
    private Map<Long, List<Coprocessor.KeyRange>> buildIndexScanKeyRangeWithIds(List<Long> ids, TiIndexInfo index, List<IndexRange> indexRanges) {
        HashMap<Long, List<Coprocessor.KeyRange>> idRanges = new HashMap<Long, List<Coprocessor.KeyRange>>();
        for (long id : ids) {
            ArrayList<Coprocessor.KeyRange> ranges = new ArrayList<Coprocessor.KeyRange>(indexRanges.size());
            for (IndexRange ir : indexRanges) {
                IndexScanKeyRangeBuilder indexScanKeyRangeBuilder = new IndexScanKeyRangeBuilder(id, index, ir);
                ranges.add(indexScanKeyRangeBuilder.compute());
            }
            idRanges.put(id, ranges);
        }
        return idRanges;
    }

    @VisibleForTesting
    Map<Long, List<Coprocessor.KeyRange>> buildIndexScanKeyRange(TiTableInfo table, TiIndexInfo index, List<IndexRange> indexRanges, List<TiPartitionDef> prunedParts) {
        Objects.requireNonNull(table, "Table cannot be null to encoding keyRange");
        Objects.requireNonNull(index, "Index cannot be null to encoding keyRange");
        Objects.requireNonNull(indexRanges, "indexRanges cannot be null to encoding keyRange");
        if (table.isPartitionEnabled()) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (TiPartitionDef pDef : prunedParts) {
                ids.add(pDef.getId());
            }
            return this.buildIndexScanKeyRangeWithIds(ids, index, indexRanges);
        }
        return this.buildIndexScanKeyRangeWithIds(ImmutableList.of(Long.valueOf(table.getId())), index, indexRanges);
    }

    boolean isCoveringIndex(List<TiColumnInfo> columns, TiIndexInfo indexColumns, boolean pkIsHandle) {
        if (columns.isEmpty()) {
            return false;
        }
        Map<String, TiIndexColumn> colInIndex = indexColumns.getIndexColumns().stream().collect(Collectors.toMap(TiIndexColumn::getName, col -> col));
        for (TiColumnInfo colInfo : columns) {
            if (pkIsHandle && colInfo.isPrimaryKey() || colInfo.getId() == -1L) continue;
            boolean colNotInIndex = false;
            if (colInIndex.containsKey(colInfo.getName())) {
                boolean isFullLength;
                TiIndexColumn indexCol = colInIndex.get(colInfo.getName());
                boolean bl = isFullLength = indexCol.isLengthUnspecified() || indexCol.getLength() == colInfo.getType().getLength();
                if (!colInfo.getName().equalsIgnoreCase(indexCol.getName()) || !isFullLength) {
                    colNotInIndex = true;
                }
            } else {
                colNotInIndex = true;
            }
            if (!colNotInIndex) continue;
            return false;
        }
        return true;
    }

    public static class TiKVScanPlan {
        private final Map<Long, List<Coprocessor.KeyRange>> keyRanges;
        private final Set<Expression> filters;
        private final double cost;
        private final TiIndexInfo index;
        private final boolean isDoubleRead;
        private final double estimatedRowCount;
        private final List<TiPartitionDef> prunedParts;
        private final TiStoreType storeType;

        private TiKVScanPlan(Map<Long, List<Coprocessor.KeyRange>> keyRanges, Set<Expression> filters, TiIndexInfo index, double cost, boolean isDoubleRead, double estimatedRowCount, List<TiPartitionDef> partDefs, TiStoreType storeType) {
            this.filters = filters;
            this.keyRanges = keyRanges;
            this.cost = cost;
            this.index = index;
            this.isDoubleRead = isDoubleRead;
            this.estimatedRowCount = estimatedRowCount;
            this.prunedParts = partDefs;
            this.storeType = storeType;
        }

        public double getEstimatedRowCount() {
            return this.estimatedRowCount;
        }

        public Map<Long, List<Coprocessor.KeyRange>> getKeyRanges() {
            return this.keyRanges;
        }

        public Set<Expression> getFilters() {
            return this.filters;
        }

        public double getCost() {
            return this.cost;
        }

        public boolean isIndexScan() {
            return this.index != null && !this.index.isFakePrimaryKey();
        }

        public TiIndexInfo getIndex() {
            return this.index;
        }

        public boolean isDoubleRead() {
            return this.isDoubleRead;
        }

        public List<TiPartitionDef> getPrunedParts() {
            return this.prunedParts;
        }

        public TiStoreType getStoreType() {
            return this.storeType;
        }

        public static class Builder {
            private final String tableName;
            private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
            private Map<Long, List<Coprocessor.KeyRange>> keyRanges;
            private Set<Expression> filters;
            private double cost;
            private TiIndexInfo index;
            private boolean isDoubleRead;
            private double estimatedRowCount = -1.0;
            private List<TiPartitionDef> prunedParts;
            private TiStoreType storeType = TiStoreType.TiKV;

            private Builder(String tableName) {
                this.tableName = tableName;
            }

            public static Builder newBuilder(String tableName) {
                return new Builder(tableName);
            }

            public Builder setKeyRanges(Map<Long, List<Coprocessor.KeyRange>> keyRanges) {
                this.keyRanges = keyRanges;
                return this;
            }

            public Builder setFilters(Set<Expression> filters) {
                this.filters = filters;
                return this;
            }

            public Builder setCost(double cost) {
                this.cost = cost;
                return this;
            }

            public Builder setIndex(TiIndexInfo index) {
                this.index = index;
                return this;
            }

            public Builder setDoubleRead(boolean doubleRead) {
                this.isDoubleRead = doubleRead;
                return this;
            }

            public Builder setEstimatedRowCount(double estimatedRowCount) {
                this.estimatedRowCount = estimatedRowCount;
                return this;
            }

            public Builder setPrunedParts(List<TiPartitionDef> prunedParts) {
                this.prunedParts = prunedParts;
                return this;
            }

            public Builder setStoreType(TiStoreType storeType) {
                this.storeType = storeType;
                return this;
            }

            public TiKVScanPlan build() {
                return new TiKVScanPlan(this.keyRanges, this.filters, this.index, this.cost, this.isDoubleRead, this.estimatedRowCount, this.prunedParts, this.storeType);
            }

            private void debug(TiDAGRequest.IndexScanType scanType) {
                String desc;
                String plan;
                switch (scanType) {
                    case TABLE_SCAN: {
                        plan = "TableScan";
                        desc = this.storeType.toString();
                        break;
                    }
                    case INDEX_SCAN: {
                        plan = "IndexScan";
                        desc = this.index.getName();
                        break;
                    }
                    case COVERING_INDEX_SCAN: {
                        plan = "CoveringIndexScan";
                        desc = this.index.getName();
                        break;
                    }
                    default: {
                        plan = "None";
                        desc = "";
                    }
                }
                this.logger.debug("[Table:" + this.tableName + "][" + plan + ":" + desc + "] cost=" + this.cost + " estimated row count=" + this.estimatedRowCount);
            }

            Builder calculateCostAndEstimateCount(TableStatistics tableStatistics, long tableColSize) {
                this.cost = 100.0;
                this.cost *= (double)tableColSize * 1.0;
                if (tableStatistics != null) {
                    this.estimatedRowCount = tableStatistics.getCount();
                }
                this.debug(TiDAGRequest.IndexScanType.TABLE_SCAN);
                return this;
            }

            Builder calculateCostAndEstimateCount(TableStatistics tableStatistics, List<Expression> conditions, List<IndexRange> irs, long indexSize, long tableColSize) {
                if (tableStatistics != null) {
                    double totalRowCount = tableStatistics.getCount();
                    IndexStatistics indexStatistics = tableStatistics.getIndexHistMap().get(this.index.getId());
                    if (indexStatistics != null) {
                        totalRowCount = indexStatistics.getHistogram().totalRowCount();
                    }
                    if (conditions.isEmpty()) {
                        this.cost = 100.0;
                        this.estimatedRowCount = totalRowCount;
                    } else if (indexStatistics != null) {
                        double idxRangeRowCnt = indexStatistics.getRowCount(irs);
                        this.cost = 100.0 * idxRangeRowCnt / totalRowCount;
                        this.estimatedRowCount = idxRangeRowCnt;
                    }
                    if (this.isDoubleRead) {
                        this.cost *= (double)tableColSize * 3.0 + (double)indexSize * 1.2;
                        this.debug(TiDAGRequest.IndexScanType.INDEX_SCAN);
                    } else {
                        this.cost *= (double)indexSize * 1.2;
                        this.debug(TiDAGRequest.IndexScanType.COVERING_INDEX_SCAN);
                    }
                }
                return this;
            }
        }
    }
}

