/*
 * Decompiled with CFR 0.152.
 */
package org.tikv.common.codec;

import javax.annotation.Nonnull;
import org.tikv.common.codec.CodecDataInput;
import org.tikv.common.exception.CodecException;
import org.tikv.shade.com.google.protobuf.ByteString;

public class CodecDataInputLittleEndian
extends CodecDataInput {
    public CodecDataInputLittleEndian(ByteString data) {
        super(data);
    }

    public CodecDataInputLittleEndian(byte[] buf) {
        super(buf);
    }

    @Override
    public short readShort() {
        int ch1 = this.readUnsignedByte();
        int ch2 = this.readUnsignedByte();
        return (short)(ch1 + (ch2 << 8));
    }

    @Override
    public int readUnsignedShort() {
        int ch1 = this.readUnsignedByte();
        int ch2 = this.readUnsignedByte();
        return ch1 + (ch2 << 8);
    }

    @Override
    public char readChar() {
        int ch1 = this.readUnsignedByte();
        int ch2 = this.readUnsignedByte();
        return (char)(ch1 + (ch2 << 8));
    }

    @Override
    public int readInt() {
        int ch1 = this.readUnsignedByte();
        int ch2 = this.readUnsignedByte();
        int ch3 = this.readUnsignedByte();
        int ch4 = this.readUnsignedByte();
        return ch1 + (ch2 << 8) + (ch3 << 16) + (ch4 << 24);
    }

    @Override
    public long readLong() {
        byte[] readBuffer = new byte[8];
        this.readFully(readBuffer, 0, 8);
        return (long)((readBuffer[0] & 0xFF) + ((readBuffer[1] & 0xFF) << 8) + ((readBuffer[2] & 0xFF) << 16)) + ((long)(readBuffer[3] & 0xFF) << 24) + ((long)(readBuffer[4] & 0xFF) << 32) + ((long)(readBuffer[5] & 0xFF) << 40) + ((long)(readBuffer[6] & 0xFF) << 48) + ((long)(readBuffer[7] & 0xFF) << 56);
    }

    @Override
    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public String readLine() {
        throw new CodecException("unimplemented");
    }

    @Override
    @Nonnull
    public String readUTF() {
        throw new CodecException("unimplemented");
    }

    @Override
    public int peekByte() {
        return super.peekByte();
    }

    @Override
    public int currentPos() {
        return super.currentPos();
    }

    @Override
    public void mark(int givenPos) {
        super.mark(givenPos);
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public boolean eof() {
        return super.eof();
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public int available() {
        return super.available();
    }

    @Override
    public byte[] toByteArray() {
        return super.toByteArray();
    }
}

