/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.ClientConnectionManager;
import io.etcd.jetcd.KV;
import io.etcd.jetcd.Txn;
import io.etcd.jetcd.Util;
import io.etcd.jetcd.api.CompactionRequest;
import io.etcd.jetcd.api.DeleteRangeRequest;
import io.etcd.jetcd.api.DeleteRangeResponse;
import io.etcd.jetcd.api.KVGrpc;
import io.etcd.jetcd.api.PutRequest;
import io.etcd.jetcd.api.RangeRequest;
import io.etcd.jetcd.api.RangeResponse;
import io.etcd.jetcd.api.TxnRequest;
import io.etcd.jetcd.api.TxnResponse;
import io.etcd.jetcd.kv.CompactResponse;
import io.etcd.jetcd.kv.DeleteResponse;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.kv.PutResponse;
import io.etcd.jetcd.op.TxnImpl;
import io.etcd.jetcd.options.CompactOption;
import io.etcd.jetcd.options.DeleteOption;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.OptionsUtil;
import io.etcd.jetcd.options.PutOption;
import java.util.concurrent.CompletableFuture;
import org.tikv.shade.com.google.common.base.Preconditions;

final class KVImpl
implements KV {
    private final ClientConnectionManager connectionManager;
    private final KVGrpc.KVFutureStub stub;
    private final ByteSequence namespace;

    KVImpl(ClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        this.stub = connectionManager.newStub(KVGrpc::newFutureStub);
        this.namespace = connectionManager.getNamespace();
    }

    @Override
    public CompletableFuture<PutResponse> put(ByteSequence key, ByteSequence value) {
        return this.put(key, value, PutOption.DEFAULT);
    }

    @Override
    public CompletableFuture<PutResponse> put(ByteSequence key, ByteSequence value, PutOption option) {
        Preconditions.checkNotNull(key, "key should not be null");
        Preconditions.checkNotNull(value, "value should not be null");
        Preconditions.checkNotNull(option, "option should not be null");
        PutRequest request = PutRequest.newBuilder().setKey(Util.prefixNamespace(key.getByteString(), this.namespace)).setValue(value.getByteString()).setLease(option.getLeaseId()).setPrevKv(option.getPrevKV()).build();
        return this.connectionManager.execute(() -> this.stub.put(request), response -> new PutResponse((io.etcd.jetcd.api.PutResponse)response, this.namespace), Util::isRetryable);
    }

    @Override
    public CompletableFuture<GetResponse> get(ByteSequence key) {
        return this.get(key, GetOption.DEFAULT);
    }

    @Override
    public CompletableFuture<GetResponse> get(ByteSequence key, GetOption option) {
        Preconditions.checkNotNull(key, "key should not be null");
        Preconditions.checkNotNull(option, "option should not be null");
        RangeRequest.Builder builder = RangeRequest.newBuilder().setKey(Util.prefixNamespace(key.getByteString(), this.namespace)).setCountOnly(option.isCountOnly()).setLimit(option.getLimit()).setRevision(option.getRevision()).setKeysOnly(option.isKeysOnly()).setSerializable(option.isSerializable()).setSortOrder(OptionsUtil.toRangeRequestSortOrder(option.getSortOrder())).setSortTarget(OptionsUtil.toRangeRequestSortTarget(option.getSortField()));
        option.getEndKey().map(endKey -> Util.prefixNamespaceToRangeEnd(endKey.getByteString(), this.namespace)).ifPresent(builder::setRangeEnd);
        RangeRequest request = builder.build();
        return this.connectionManager.execute(() -> this.stub.range(request), response -> new GetResponse((RangeResponse)response, this.namespace), Util::isRetryable);
    }

    @Override
    public CompletableFuture<DeleteResponse> delete(ByteSequence key) {
        return this.delete(key, DeleteOption.DEFAULT);
    }

    @Override
    public CompletableFuture<DeleteResponse> delete(ByteSequence key, DeleteOption option) {
        Preconditions.checkNotNull(key, "key should not be null");
        Preconditions.checkNotNull(option, "option should not be null");
        DeleteRangeRequest.Builder builder = DeleteRangeRequest.newBuilder().setKey(Util.prefixNamespace(key.getByteString(), this.namespace)).setPrevKv(option.isPrevKV());
        option.getEndKey().map(endKey -> Util.prefixNamespaceToRangeEnd(endKey.getByteString(), this.namespace)).ifPresent(builder::setRangeEnd);
        DeleteRangeRequest request = builder.build();
        return this.connectionManager.execute(() -> this.stub.deleteRange(request), response -> new DeleteResponse((DeleteRangeResponse)response, this.namespace), Util::isRetryable);
    }

    @Override
    public CompletableFuture<CompactResponse> compact(long rev) {
        return this.compact(rev, CompactOption.DEFAULT);
    }

    @Override
    public CompletableFuture<CompactResponse> compact(long rev, CompactOption option) {
        Preconditions.checkNotNull(option, "option should not be null");
        CompactionRequest request = CompactionRequest.newBuilder().setRevision(rev).setPhysical(option.isPhysical()).build();
        return this.connectionManager.execute(() -> this.stub.compact(request), CompactResponse::new, Util::isRetryable);
    }

    @Override
    public Txn txn() {
        return TxnImpl.newTxn(request -> this.connectionManager.execute(() -> this.stub.txn((TxnRequest)request), response -> new io.etcd.jetcd.kv.TxnResponse((TxnResponse)response, this.namespace), Util::isRetryable), this.namespace);
    }
}

