/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.report;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.testing.templateengine.report.ITestReporter;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.testing.templateengine.testable.ITestIterator;
import org.thymeleaf.testing.templateengine.testable.ITestParallelizer;
import org.thymeleaf.testing.templateengine.testable.ITestResult;
import org.thymeleaf.testing.templateengine.testable.ITestSequence;

public abstract class AbstractTestReporter
implements ITestReporter {
    private final Map<String, ITestResult> resultByTestName = new LinkedHashMap<String, ITestResult>();
    private final Map<String, Long> executionTimeMsByTestName = new LinkedHashMap<String, Long>();
    private boolean allOK = true;
    private long totalExecutionTimeMs = 0L;

    protected AbstractTestReporter() {
    }

    @Override
    public final void testStart(String executionId, int nestingLevel, ITest test, String testName) {
        this.reportTestStart(executionId, nestingLevel, test, testName);
    }

    protected void reportTestStart(String executionId, int nestingLevel, ITest test, String testName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void testEnd(String executionId, int nestingLevel, ITest test, String testName, ITestResult result, long executionTimeNanos) {
        AbstractTestReporter abstractTestReporter = this;
        synchronized (abstractTestReporter) {
            this.resultByTestName.put(testName, result);
            this.executionTimeMsByTestName.put(testName, executionTimeNanos);
            this.allOK = this.allOK && result.isOK();
            this.totalExecutionTimeMs += executionTimeNanos;
        }
        this.reportTestEnd(executionId, nestingLevel, test, testName, result, executionTimeNanos);
    }

    protected void reportTestEnd(String executionId, int nestingLevel, ITest test, String testName, ITestResult result, long executionTimeNanos) {
    }

    @Override
    public final synchronized boolean isAllOK() {
        return this.allOK;
    }

    @Override
    public final synchronized long getTotalExecutionTimeMs() {
        return this.totalExecutionTimeMs;
    }

    @Override
    public final synchronized Set<String> getAllTestNames() {
        return this.resultByTestName.keySet();
    }

    @Override
    public final synchronized ITestResult getResultByTestName(String testName) {
        return this.resultByTestName.get(testName);
    }

    @Override
    public final synchronized long getExecutionTimeMsByTestName(String testName) {
        Long value = this.executionTimeMsByTestName.get(testName);
        if (value == null) {
            return -1L;
        }
        return value;
    }

    @Override
    public final synchronized void reset() {
        this.resultByTestName.clear();
        this.executionTimeMsByTestName.clear();
        this.allOK = true;
        this.totalExecutionTimeMs = 0L;
    }

    @Override
    public void executionStart(String executionId) {
    }

    @Override
    public void executionEnd(String executionId, int okTests, int totalTests, long executionTimeNanos) {
    }

    @Override
    public void sequenceStart(String executionId, int nestingLevel, ITestSequence sequence) {
    }

    @Override
    public void sequenceEnd(String executionId, int nestingLevel, ITestSequence sequence, int okTests, int totalTests, long executionTimeNanos) {
    }

    @Override
    public void iteratorStart(String executionId, int nestingLevel, ITestIterator iterator) {
    }

    @Override
    public void iteratorEnd(String executionId, int nestingLevel, ITestIterator iterator, int okTests, int totalTests, long executionTimeNanos) {
    }

    @Override
    public void iterationStart(String executionId, int nestingLevel, ITestIterator iterator, int iterationNumber) {
    }

    @Override
    public void iterationEnd(String executionId, int nestingLevel, ITestIterator iterator, int iterationNumber, int okTests, int totalTests, long executionTimeNanos) {
    }

    @Override
    public void parallelizerStart(String executionId, int nestingLevel, ITestParallelizer parallelizer) {
    }

    @Override
    public void parallelizerEnd(String executionId, int nestingLevel, ITestParallelizer parallelizer, int okTests, int totalTests, long executionTimeNanos) {
    }

    @Override
    public void parallelThreadStart(String executionId, int nestingLevel, ITestParallelizer parallelizer, int threadNumber) {
    }

    @Override
    public void parallelThreadEnd(String executionId, int nestingLevel, ITestParallelizer parallelizer, int threadNumber, int okTests, int totalTests, long executionTimeNanos) {
    }
}

