/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.context.web;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import org.thymeleaf.testing.templateengine.context.web.ITestWebExchangeBuilder;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.testing.templateengine.util.JakartaServletMockUtils;
import org.thymeleaf.testing.templateengine.util.TestNamingUtils;
import org.thymeleaf.util.Validate;
import org.thymeleaf.web.IWebExchange;
import org.thymeleaf.web.servlet.JakartaServletWebApplication;

public class JakartaServletTestWebExchangeBuilder
implements ITestWebExchangeBuilder {
    private String method = "GET";
    private String scheme = "http";
    private String serverName = "testing-server";
    private int port = 80;
    private String contextPath = "/testing";
    private String contentType = "text/html";
    private String characterEncoding = "UTF-8";
    private Function<String, String> transformUrlFunction = JakartaServletMockUtils.DEFAULT_TRANSFORM_URL_FUNCTION;

    private JakartaServletTestWebExchangeBuilder() {
    }

    public static JakartaServletTestWebExchangeBuilder create() {
        return new JakartaServletTestWebExchangeBuilder();
    }

    public JakartaServletTestWebExchangeBuilder method(String method) {
        Validate.notNull((Object)method, (String)"Method cannot be null");
        this.method = method;
        return this;
    }

    public JakartaServletTestWebExchangeBuilder scheme(String scheme) {
        Validate.notNull((Object)scheme, (String)"Scheme cannot be null");
        this.scheme = scheme;
        return this;
    }

    public JakartaServletTestWebExchangeBuilder serverName(String serverName) {
        Validate.notNull((Object)serverName, (String)"Server Name cannot be null");
        this.serverName = serverName;
        return this;
    }

    public JakartaServletTestWebExchangeBuilder port(int port) {
        this.port = port;
        return this;
    }

    public JakartaServletTestWebExchangeBuilder contextPath(String contextPath) {
        Validate.notNull((Object)contextPath, (String)"Context Path cannot be null");
        this.contextPath = contextPath;
        return this;
    }

    public JakartaServletTestWebExchangeBuilder contentType(String contentType) {
        Validate.notNull((Object)contentType, (String)"Content Type cannot be null");
        this.contentType = contentType;
        return this;
    }

    public JakartaServletTestWebExchangeBuilder characterEncoding(String characterEncoding) {
        Validate.notNull((Object)characterEncoding, (String)"Character Encoding cannot be null");
        this.characterEncoding = characterEncoding;
        return this;
    }

    public JakartaServletTestWebExchangeBuilder transformUrlFunction(Function<String, String> transformUrlFunction) {
        Validate.notNull(transformUrlFunction, (String)"transformUrl Function cannot be null");
        this.transformUrlFunction = transformUrlFunction;
        return this;
    }

    @Override
    public IWebExchange buildExchange(ITest test, Map<String, Object> exchangeAttributes, Map<String, String[]> requestParameters, Map<String, Object> sessionAttributes, Map<String, Object> applicationAttributes, Locale locale) {
        Validate.notNull((Object)test, (String)"Test cannot be null");
        Validate.notNull(exchangeAttributes, (String)"Exchange attribute map cannot be null");
        Validate.notNull(requestParameters, (String)"Request parameter map cannot be null");
        Validate.notNull(applicationAttributes, (String)"Application attribute map cannot be null");
        Validate.notNull((Object)locale, (String)"Locale cannot be null");
        ServletContext servletContext = JakartaServletMockUtils.buildServletContext().attributeMap(applicationAttributes).build();
        HttpSession httpSession = JakartaServletMockUtils.buildSession(servletContext).attributeMap(sessionAttributes).build();
        HttpServletResponse httpServletResponse = JakartaServletMockUtils.buildResponse().transformUrlFunction(this.transformUrlFunction).build();
        HttpServletRequest httpServletRequest = JakartaServletMockUtils.buildRequest(servletContext, TestNamingUtils.normalizeTestName(test.getName())).session(httpSession).attributeMap(exchangeAttributes).parameterMap(requestParameters).method(this.method).scheme(this.scheme).serverName(this.serverName).port(this.port).contextPath(this.contextPath).contentType(this.contentType).characterEncoding(this.characterEncoding).locale(locale).build();
        return JakartaServletWebApplication.buildApplication((ServletContext)servletContext).buildExchange(httpServletRequest, httpServletResponse);
    }
}

