/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.test.data;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.util.Validate;

public class StandardTestRawData {
    private final ITestResource resource;
    private final Map<String, Map<String, String>> valuesByFieldAndQualifier;

    public StandardTestRawData(ITestResource resource) {
        Validate.notNull((Object)resource, (String)"Resource cannot be null");
        this.resource = resource;
        this.valuesByFieldAndQualifier = new HashMap<String, Map<String, String>>();
    }

    public ITestResource getTestResource() {
        return this.resource;
    }

    public Set<String> getFieldNames() {
        return this.valuesByFieldAndQualifier.keySet();
    }

    public Set<String> getQualifiersForField(String fieldName) {
        Validate.notNull((Object)fieldName, (String)"Field name cannot be null");
        Map<String, String> valuesByQualifierForField = this.getValuesByQualifierForField(fieldName);
        if (valuesByQualifierForField == null) {
            return Collections.emptySet();
        }
        return valuesByQualifierForField.keySet();
    }

    public String getValueForFieldAndQualifier(String fieldName, String fieldQualifier) {
        Validate.notNull((Object)fieldName, (String)"Field name cannot be null");
        Map<String, String> valuesByQualifierForField = this.getValuesByQualifierForField(fieldName);
        if (valuesByQualifierForField == null) {
            return null;
        }
        return valuesByQualifierForField.get(fieldQualifier);
    }

    public Map<String, String> getValuesByQualifierForField(String fieldName) {
        Validate.notNull((Object)fieldName, (String)"Field name cannot be null");
        Map<String, String> valuesByQualifierForField = this.valuesByFieldAndQualifier.get(fieldName);
        if (valuesByQualifierForField == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(valuesByQualifierForField);
    }

    public void setValue(String fieldName, String fieldQualifier, String value) {
        Validate.notNull((Object)fieldName, (String)"Field name cannot be null");
        Map<String, String> valuesByQualifierForField = this.valuesByFieldAndQualifier.get(fieldName);
        if (valuesByQualifierForField == null) {
            valuesByQualifierForField = new HashMap<String, String>();
            this.valuesByFieldAndQualifier.put(fieldName, valuesByQualifierForField);
        }
        valuesByQualifierForField.put(fieldQualifier, value);
    }
}

