/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.context.web;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.ConversionService;
import org.springframework.validation.BindingResult;
import org.springframework.validation.DataBinder;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.support.StaticWebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;
import org.springframework.web.servlet.support.RequestContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.testing.templateengine.context.web.SpringVersionSpecificContextInitialization;
import org.thymeleaf.testing.templateengine.context.web.WebProcessingContextBuilder;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.testable.ITest;

public class SpringWebProcessingContextBuilder
extends WebProcessingContextBuilder {
    public static final String DEFAULT_BINDING_MODEL_VARIABLE_NAME = "model";
    public static final String DEFAULT_APPLICATION_CONTEXT_CONFIG_LOCATION = "classpath:applicationContext.xml";
    private String applicationContextConfigLocation = "classpath:applicationContext.xml";
    private boolean shareAppContextForAllTests = false;
    private String sharedContextConfigLocation = null;
    private WebApplicationContext sharedApplicationContext = null;

    public String getApplicationContextConfigLocation() {
        return this.applicationContextConfigLocation;
    }

    public void setApplicationContextConfigLocation(String applicationContextConfigLocation) {
        this.applicationContextConfigLocation = applicationContextConfigLocation;
    }

    public boolean getShareAppContextForAllTests() {
        return this.shareAppContextForAllTests;
    }

    public void setShareAppContextForAllTests(boolean shareAppContextForAllTests) {
        this.shareAppContextForAllTests = shareAppContextForAllTests;
    }

    @Override
    protected final void doAdditionalVariableProcessing(ITest test, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Locale locale, Map<String, Object> variables) {
        WebApplicationContext appCtx = this.createApplicationContext(test, request, response, servletContext, locale, variables);
        servletContext.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)appCtx);
        request.setAttribute(DispatcherServlet.WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)appCtx);
        ServletWebRequest servletWebRequest = new ServletWebRequest(request, response);
        RequestContextHolder.setRequestAttributes((RequestAttributes)servletWebRequest);
        ConversionService conversionService = this.getConversionService((ApplicationContext)appCtx);
        RequestContext requestContext = new RequestContext(request, response, servletContext, variables);
        variables.put("springMacroRequestContext", requestContext);
        variables.put("springRequestContext", requestContext);
        SpringVersionSpecificContextInitialization.versionSpecificAdditionalVariableProcessing((ApplicationContext)appCtx, conversionService, request, response, servletContext, variables);
        this.initializeBindingResults(test, conversionService, locale, variables);
        this.initSpring((ApplicationContext)appCtx, test, request, response, servletContext, locale, variables);
    }

    @Override
    protected IWebContext doCreateWebContextInstance(ITest test, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Locale locale, Map<String, Object> variables) {
        ApplicationContext appCtx = (ApplicationContext)servletContext.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE);
        return SpringVersionSpecificContextInitialization.versionSpecificCreateContextInstance(appCtx, request, response, servletContext, locale, variables);
    }

    protected void initBinder(String bindingVariableName, Object bindingObject, ITest test, DataBinder dataBinder, Locale locale, Map<String, Object> variables) {
    }

    protected void initBindingResult(String bindingVariableName, Object bindingObject, ITest test, BindingResult bindingResult, Locale locale, Map<String, Object> variables) {
    }

    protected WebApplicationContext createApplicationContext(ITest test, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Locale locale, Map<String, Object> variables) {
        String nullSafeConfigLocation;
        String string = nullSafeConfigLocation = this.applicationContextConfigLocation == null ? "null" : this.applicationContextConfigLocation;
        if (this.shareAppContextForAllTests && this.sharedContextConfigLocation != null) {
            if (!this.sharedContextConfigLocation.equals(nullSafeConfigLocation)) {
                throw new RuntimeException("Invalid configuration for context builder. Builder is configured to share Spring application context across executions, but more than one different context config locations are being used, so this option cannot be used.");
            }
            return this.sharedApplicationContext;
        }
        if (this.applicationContextConfigLocation == null) {
            WebApplicationContext appCtx = SpringWebProcessingContextBuilder.createEmptyStaticApplicationContext(servletContext);
            if (this.shareAppContextForAllTests) {
                this.sharedContextConfigLocation = nullSafeConfigLocation;
                this.sharedApplicationContext = appCtx;
            }
            return appCtx;
        }
        XmlWebApplicationContext appCtx = new XmlWebApplicationContext();
        appCtx.setServletContext(servletContext);
        appCtx.setConfigLocation(this.applicationContextConfigLocation);
        try {
            appCtx.refresh();
        }
        catch (BeanDefinitionStoreException e) {
            if (e.getCause() != null && e.getCause() instanceof FileNotFoundException) {
                throw new TestEngineExecutionException("Cannot find ApplicationContext config location \"" + this.applicationContextConfigLocation + "\". If your tests don't need to define any Spring beans, set the 'applicationContextConfigLocation' field of your ProcessingContext builder to null.", e);
            }
            throw e;
        }
        if (this.shareAppContextForAllTests) {
            this.sharedContextConfigLocation = nullSafeConfigLocation;
            this.sharedApplicationContext = appCtx;
        }
        return appCtx;
    }

    private static WebApplicationContext createEmptyStaticApplicationContext(ServletContext servletContext) {
        StaticWebApplicationContext applicationContext = new StaticWebApplicationContext();
        applicationContext.setServletContext(servletContext);
        return applicationContext;
    }

    protected void initSpring(ApplicationContext applicationContext, ITest test, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Locale locale, Map<String, Object> variables) {
    }

    private ConversionService getConversionService(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            return null;
        }
        Map conversionServices = applicationContext.getBeansOfType(ConversionService.class);
        if (conversionServices.size() == 0) {
            return null;
        }
        return (ConversionService)conversionServices.values().toArray()[0];
    }

    private void initializeBindingResults(ITest test, ConversionService conversionService, Locale locale, Map<String, Object> variables) {
        ArrayList<String> variableNames = new ArrayList<String>(variables.keySet());
        for (String variableName : variableNames) {
            String bindingVariableName;
            Object bindingObject;
            if (!SpringWebProcessingContextBuilder.isBindingCandidate(variableName, bindingObject = variables.get(variableName)) || variables.containsKey(bindingVariableName = BindingResult.MODEL_KEY_PREFIX + variableName)) continue;
            WebDataBinder dataBinders = this.createBinding(test, variableName, bindingVariableName, bindingObject, conversionService, locale, variables);
            variables.put(bindingVariableName, dataBinders.getBindingResult());
        }
    }

    private static boolean isBindingCandidate(String variableName, Object bindingObject) {
        if (variableName.startsWith(BindingResult.MODEL_KEY_PREFIX)) {
            return false;
        }
        return bindingObject != null && !bindingObject.getClass().isArray() && !(bindingObject instanceof Collection) && !(bindingObject instanceof Map) && !BeanUtils.isSimpleValueType(bindingObject.getClass());
    }

    private WebDataBinder createBinding(ITest test, String variableName, String bindingVariableName, Object bindingObject, ConversionService conversionService, Locale locale, Map<String, Object> variables) {
        WebDataBinder dataBinder = new WebDataBinder(bindingObject, bindingVariableName);
        dataBinder.setConversionService(conversionService);
        Map<String, Object> unmodifiableVariables = Collections.unmodifiableMap(variables);
        this.initBinder(variableName, bindingObject, test, (DataBinder)dataBinder, locale, unmodifiableVariables);
        this.initBindingResult(variableName, bindingObject, test, dataBinder.getBindingResult(), locale, unmodifiableVariables);
        return dataBinder;
    }
}

