/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.context.web;

import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.context.ApplicationContext;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.thymeleaf.testing.templateengine.context.web.SpringWebProcessingContextBuilder;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.util.Validate;

public class SpringSecurityWebProcessingContextBuilder
extends SpringWebProcessingContextBuilder {
    public static final String DEFAULT_AUTHENTICATION_MANAGER_BEAN_NAME = "authenticationManager";
    public static final String DEFAULT_USERNAME_VARIABLE_NAME = "j_username";
    public static final String DEFAULT_PASSWORD_VARIABLE_NAME = "j_password";
    private String authenticationManagerBeanName = "authenticationManager";

    public String getAuthenticationManagerBeanName() {
        return this.authenticationManagerBeanName;
    }

    public void setAuthenticationManagerBeanName(String authenticationManagerBeanName) {
        Validate.notNull((Object)authenticationManagerBeanName, (String)"Name of AuthenticationManager bean cannot be set to null");
        this.authenticationManagerBeanName = authenticationManagerBeanName;
    }

    @Override
    protected final void initSpring(ApplicationContext applicationContext, ITest test, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Locale locale, Map<String, Object> variables) {
        super.initSpring(applicationContext, test, request, response, servletContext, locale, variables);
        SecurityContextHolder.setStrategyName((String)"MODE_THREADLOCAL");
        SecurityContextHolder.clearContext();
        AuthenticationManager authenticationManager = (AuthenticationManager)applicationContext.getBean(this.authenticationManagerBeanName);
        Authentication authentication = this.getAuthentication(applicationContext, test, request, response, servletContext, locale, variables);
        if (authentication != null) {
            Authentication fullAuthentication = authenticationManager.authenticate(authentication);
            SecurityContext securityContext = SecurityContextHolder.getContext();
            securityContext.setAuthentication(fullAuthentication);
            HttpSession session = request.getSession(true);
            session.setAttribute("SPRING_SECURITY_CONTEXT", (Object)securityContext);
        }
    }

    protected Authentication getAuthentication(ApplicationContext applicationContext, ITest test, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext, Locale locale, Map<String, Object> variables) {
        Object usernameObj = variables.get(DEFAULT_USERNAME_VARIABLE_NAME);
        Object passwordObj = variables.get(DEFAULT_PASSWORD_VARIABLE_NAME);
        if (usernameObj == null || passwordObj == null) {
            return null;
        }
        return new UsernamePasswordAuthenticationToken((Object)usernameObj.toString(), (Object)passwordObj.toString());
    }
}

