/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.standard.test.evaluator.field.defaultevaluators;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.thymeleaf.testing.templateengine.exception.TestEngineExecutionException;
import org.thymeleaf.testing.templateengine.messages.ITestMessagesForLocale;
import org.thymeleaf.testing.templateengine.messages.TestMessagesForLocale;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.resource.ITestResourceResolver;
import org.thymeleaf.testing.templateengine.standard.test.data.StandardTestEvaluatedField;
import org.thymeleaf.testing.templateengine.standard.test.evaluator.field.defaultevaluators.AbstractStandardTestFieldEvaluator;

public class DefaultMessagesStandardTestFieldEvaluator
extends AbstractStandardTestFieldEvaluator {
    public static final DefaultMessagesStandardTestFieldEvaluator INSTANCE = new DefaultMessagesStandardTestFieldEvaluator();

    private DefaultMessagesStandardTestFieldEvaluator() {
        super(ITestMessagesForLocale.class);
    }

    protected StandardTestEvaluatedField getValue(String executionId, ITestResource resource, ITestResourceResolver testResourceResolver, String fieldName, String fieldQualifier, String fieldValue) {
        if (fieldValue == null || fieldValue.trim().equals("")) {
            return StandardTestEvaluatedField.forDefaultValue(new TestMessagesForLocale());
        }
        Properties properties = new Properties();
        try {
            byte[] valueAsBytes = fieldValue.getBytes("ISO-8859-1");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(valueAsBytes);
            properties.load(inputStream);
        }
        catch (Throwable t) {
            throw new TestEngineExecutionException("Error while reading context specification", t);
        }
        HashMap<String, String> readMessages = new HashMap<String, String>();
        for (Map.Entry entry : properties.entrySet()) {
            String messageKey = (String)entry.getKey();
            String messageValue = (String)entry.getValue();
            readMessages.put(messageKey, messageValue);
        }
        TestMessagesForLocale testMessagesForLocale = new TestMessagesForLocale();
        testMessagesForLocale.setMessagesForLocale(readMessages);
        return StandardTestEvaluatedField.forSpecifiedValue(testMessagesForLocale);
    }
}

