/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.resource;

import org.thymeleaf.testing.templateengine.resource.AbstractTestResource;
import org.thymeleaf.testing.templateengine.resource.ITestResourceItem;
import org.thymeleaf.testing.templateengine.util.EscapeUtils;
import org.thymeleaf.util.Validate;

public class StringTestResource
extends AbstractTestResource
implements ITestResourceItem {
    private final String TYPE = "classpath";
    private final String str;

    public StringTestResource(String name, String str) {
        super(name);
        Validate.notNull((Object)name, (String)"Name cannot be null");
        Validate.notNull((Object)str, (String)"Resource string cannot be null");
        this.str = str;
    }

    public String getType() {
        return this.TYPE;
    }

    public String readAsText() {
        return EscapeUtils.unescapeUnicode(this.str);
    }
}

