/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.requestdata;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.support.RequestContext;
import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.context.IWebContext;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.spring4.requestdata.IRequestDataValueProcessorDelegate;
import org.thymeleaf.spring4.util.SpringVersionUtils;
import org.thymeleaf.util.ClassLoaderUtils;

public final class RequestDataValueProcessorUtils {
    private static final boolean canApply;
    private static final String SPRING4_DELEGATE_CLASS;
    private static final IRequestDataValueProcessorDelegate spring4Delegate;
    private static final Logger LOGGER;

    public static String processAction(ITemplateContext context, String action, String httpMethod) {
        if (!canApply || !(context instanceof IWebContext)) {
            return action;
        }
        RequestContext requestContext = (RequestContext)context.getVariable("springRequestContext");
        if (requestContext == null) {
            return action;
        }
        if (spring4Delegate != null) {
            return spring4Delegate.processAction(requestContext, ((IWebContext)context).getRequest(), action, httpMethod);
        }
        throw new TemplateProcessingException("According to the detected Spring version info, a RequestDataValueProcessor delegate should be available, but none seem applicable");
    }

    public static String processFormFieldValue(ITemplateContext context, String name, String value, String type) {
        if (!canApply || !(context instanceof IWebContext)) {
            return value;
        }
        RequestContext requestContext = (RequestContext)context.getVariable("springRequestContext");
        if (requestContext == null) {
            return value;
        }
        if (spring4Delegate != null) {
            return spring4Delegate.processFormFieldValue(requestContext, ((IWebContext)context).getRequest(), name, value, type);
        }
        throw new TemplateProcessingException("According to the detected Spring version info, a RequestDataValueProcessor delegate should be available, but none seem applicable");
    }

    public static Map<String, String> getExtraHiddenFields(ITemplateContext context) {
        if (!canApply || !(context instanceof IWebContext)) {
            return null;
        }
        RequestContext requestContext = (RequestContext)context.getVariable("springRequestContext");
        if (requestContext == null) {
            return null;
        }
        if (spring4Delegate != null) {
            return spring4Delegate.getExtraHiddenFields(requestContext, ((IWebContext)context).getRequest());
        }
        throw new TemplateProcessingException("According to the detected Spring version info, a RequestDataValueProcessor delegate should be available, but none seem applicable");
    }

    public static String processUrl(ITemplateContext context, String url) {
        if (!canApply || !(context instanceof IWebContext)) {
            return url;
        }
        RequestContext requestContext = (RequestContext)context.getVariable("springRequestContext");
        if (requestContext == null) {
            return url;
        }
        if (spring4Delegate != null) {
            return spring4Delegate.processUrl(requestContext, ((IWebContext)context).getRequest(), url);
        }
        throw new TemplateProcessingException("According to the detected Spring version info, a RequestDataValueProcessor delegate should be available, but none seem applicable");
    }

    private RequestDataValueProcessorUtils() {
    }

    public static void main(String[] args) {
        System.out.println(SPRING4_DELEGATE_CLASS);
    }

    static {
        SPRING4_DELEGATE_CLASS = RequestDataValueProcessorUtils.class.getPackage().getName() + ".RequestDataValueProcessor4Delegate";
        LOGGER = LoggerFactory.getLogger(RequestDataValueProcessorUtils.class);
        canApply = SpringVersionUtils.isSpring40AtLeast();
        if (canApply) {
            try {
                Class implClass = ClassLoaderUtils.loadClass((String)SPRING4_DELEGATE_CLASS);
                spring4Delegate = (IRequestDataValueProcessorDelegate)implClass.newInstance();
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError((Throwable)new ConfigurationException("Environment has been detected to be at least Spring 4, but thymeleaf could not initialize a delegate of class \"" + SPRING4_DELEGATE_CLASS + "\"", (Throwable)e));
            }
        } else {
            LOGGER.warn("[THYMELEAF] You seem to be using the thymeleaf-spring4 module with a Spring version prior to 4.0. Even though most features should work OK, support for CSRF protection on websites will be disabled due to incompatibilities between the different versions of the RequestDataValueProcessor interface in versions 4.x and 3.x.");
            spring4Delegate = null;
        }
    }
}

