/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring4.templateresolver;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.spring4.resourceresolver.SpringResourceResourceResolver;
import org.thymeleaf.templateresolver.TemplateResolver;
import org.thymeleaf.util.Validate;

public class SpringResourceTemplateResolver
extends TemplateResolver
implements ApplicationContextAware,
InitializingBean {
    private final SpringResourceResourceResolver resourceResolver = new SpringResourceResourceResolver();
    private ApplicationContext applicationContext = null;

    public SpringResourceTemplateResolver() {
        super.setResourceResolver((IResourceResolver)this.resourceResolver);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Validate.notNull((Object)this.applicationContext, (String)"ApplicationContext has not been initialized in resource resolver. TemplateResolver or ResourceResolver might not have been correctly configured by the Spring Application Context.");
        AutowireCapableBeanFactory beanFactory = this.applicationContext.getAutowireCapableBeanFactory();
        beanFactory.initializeBean((Object)this.resourceResolver, "springResourceResolver");
    }

    public void setResourceResolver(IResourceResolver resourceResolver) {
        throw new ConfigurationException("Cannot set a resource resolver on " + ((Object)((Object)this)).getClass().getName() + ". If " + "you want to set your own resource resolver, use " + TemplateResolver.class.getName() + "instead");
    }
}

