/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.view;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;
import org.springframework.util.PatternMatchUtils;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.AbstractCachingViewResolver;
import org.springframework.web.servlet.view.InternalResourceView;
import org.springframework.web.servlet.view.RedirectView;
import org.thymeleaf.ITemplateEngine;
import org.thymeleaf.spring3.view.AbstractThymeleafView;
import org.thymeleaf.spring3.view.ThymeleafView;

public class ThymeleafViewResolver
extends AbstractCachingViewResolver
implements Ordered {
    private static final Logger vrlogger = LoggerFactory.getLogger(ThymeleafViewResolver.class);
    public static final String REDIRECT_URL_PREFIX = "redirect:";
    public static final String FORWARD_URL_PREFIX = "forward:";
    private boolean redirectContextRelative = true;
    private boolean redirectHttp10Compatible = true;
    private boolean alwaysProcessRedirectAndForward = true;
    private Class<? extends AbstractThymeleafView> viewClass = ThymeleafView.class;
    private String[] viewNames = null;
    private String[] excludedViewNames = null;
    private int order = Integer.MAX_VALUE;
    private final Map<String, Object> staticVariables = new LinkedHashMap<String, Object>(10);
    private String contentType = null;
    private String characterEncoding = null;
    private ITemplateEngine templateEngine;

    public void setViewClass(Class<? extends AbstractThymeleafView> viewClass) {
        if (viewClass == null || !AbstractThymeleafView.class.isAssignableFrom(viewClass)) {
            throw new IllegalArgumentException("Given view class [" + (viewClass != null ? viewClass.getName() : null) + "] is not of type [" + AbstractThymeleafView.class.getName() + "]");
        }
        this.viewClass = viewClass;
    }

    protected Class<? extends AbstractThymeleafView> getViewClass() {
        return this.viewClass;
    }

    public ITemplateEngine getTemplateEngine() {
        return this.templateEngine;
    }

    public void setTemplateEngine(ITemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public Map<String, Object> getStaticVariables() {
        return Collections.unmodifiableMap(this.staticVariables);
    }

    public void addStaticVariable(String name, Object value) {
        this.staticVariables.put(name, value);
    }

    public void setStaticVariables(Map<String, ?> variables) {
        if (variables != null) {
            for (Map.Entry<String, ?> entry : variables.entrySet()) {
                this.addStaticVariable(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setRedirectContextRelative(boolean redirectContextRelative) {
        this.redirectContextRelative = redirectContextRelative;
    }

    public boolean isRedirectContextRelative() {
        return this.redirectContextRelative;
    }

    public void setRedirectHttp10Compatible(boolean redirectHttp10Compatible) {
        this.redirectHttp10Compatible = redirectHttp10Compatible;
    }

    public boolean isRedirectHttp10Compatible() {
        return this.redirectHttp10Compatible;
    }

    public void setAlwaysProcessRedirectAndForward(boolean alwaysProcessRedirectAndForward) {
        this.alwaysProcessRedirectAndForward = alwaysProcessRedirectAndForward;
    }

    public boolean getAlwaysProcessRedirectAndForward() {
        return this.alwaysProcessRedirectAndForward;
    }

    public void setViewNames(String[] viewNames) {
        this.viewNames = viewNames;
    }

    public String[] getViewNames() {
        return this.viewNames;
    }

    public void setExcludedViewNames(String[] excludedViewNames) {
        this.excludedViewNames = excludedViewNames;
    }

    public String[] getExcludedViewNames() {
        return this.excludedViewNames;
    }

    protected boolean canHandle(String viewName, Locale locale) {
        String[] viewNamesToBeProcessed = this.getViewNames();
        String[] viewNamesNotToBeProcessed = this.getExcludedViewNames();
        return !(viewNamesToBeProcessed != null && !PatternMatchUtils.simpleMatch((String[])viewNamesToBeProcessed, (String)viewName) || viewNamesNotToBeProcessed != null && PatternMatchUtils.simpleMatch((String[])viewNamesNotToBeProcessed, (String)viewName));
    }

    protected View createView(String viewName, Locale locale) throws Exception {
        if (!this.alwaysProcessRedirectAndForward && !this.canHandle(viewName, locale)) {
            vrlogger.trace("[THYMELEAF] View \"{}\" cannot be handled by ThymeleafViewResolver. Passing on to the next resolver in the chain.", (Object)viewName);
            return null;
        }
        if (viewName.startsWith(REDIRECT_URL_PREFIX)) {
            vrlogger.trace("[THYMELEAF] View \"{}\" is a redirect, and will not be handled directly by ThymeleafViewResolver.", (Object)viewName);
            String redirectUrl = viewName.substring(REDIRECT_URL_PREFIX.length(), viewName.length());
            RedirectView view = new RedirectView(redirectUrl, this.isRedirectContextRelative(), this.isRedirectHttp10Compatible());
            return (View)this.getApplicationContext().getAutowireCapableBeanFactory().initializeBean((Object)view, viewName);
        }
        if (viewName.startsWith(FORWARD_URL_PREFIX)) {
            vrlogger.trace("[THYMELEAF] View \"{}\" is a forward, and will not be handled directly by ThymeleafViewResolver.", (Object)viewName);
            String forwardUrl = viewName.substring(FORWARD_URL_PREFIX.length(), viewName.length());
            return new InternalResourceView(forwardUrl);
        }
        if (this.alwaysProcessRedirectAndForward && !this.canHandle(viewName, locale)) {
            vrlogger.trace("[THYMELEAF] View \"{}\" cannot be handled by ThymeleafViewResolver. Passing on to the next resolver in the chain.", (Object)viewName);
            return null;
        }
        vrlogger.trace("[THYMELEAF] View {} will be handled by ThymeleafViewResolver and a {} instance will be created for it", (Object)viewName, (Object)this.viewClass.getSimpleName());
        return this.loadView(viewName, locale);
    }

    protected View loadView(String viewName, Locale locale) throws Exception {
        AbstractThymeleafView view;
        Class viewBeanType;
        AutowireCapableBeanFactory beanFactory = this.getApplicationContext().getAutowireCapableBeanFactory();
        boolean viewBeanExists = beanFactory.containsBean(viewName);
        Class clazz = viewBeanType = viewBeanExists ? beanFactory.getType(viewName) : null;
        if (viewBeanExists && viewBeanType != null && AbstractThymeleafView.class.isAssignableFrom(viewBeanType)) {
            BeanDefinition viewBeanDefinition;
            BeanDefinition beanDefinition = viewBeanDefinition = beanFactory instanceof ConfigurableListableBeanFactory ? ((ConfigurableListableBeanFactory)beanFactory).getBeanDefinition(viewName) : null;
            if (viewBeanDefinition == null || !viewBeanDefinition.isPrototype()) {
                AbstractThymeleafView viewInstance = (AbstractThymeleafView)((Object)BeanUtils.instantiateClass(this.getViewClass()));
                view = (AbstractThymeleafView)((Object)beanFactory.configureBean((Object)viewInstance, viewName));
            } else {
                view = (AbstractThymeleafView)((Object)beanFactory.getBean(viewName));
            }
        } else {
            AbstractThymeleafView viewInstance = (AbstractThymeleafView)((Object)BeanUtils.instantiateClass(this.getViewClass()));
            if (viewBeanExists && viewBeanType == null) {
                beanFactory.autowireBeanProperties((Object)viewInstance, 0, false);
                beanFactory.applyBeanPropertyValues((Object)viewInstance, viewName);
                view = (AbstractThymeleafView)((Object)beanFactory.initializeBean((Object)viewInstance, viewName));
            } else {
                beanFactory.autowireBeanProperties((Object)viewInstance, 0, false);
                view = (AbstractThymeleafView)((Object)beanFactory.initializeBean((Object)viewInstance, viewName));
            }
        }
        view.setTemplateEngine(this.getTemplateEngine());
        view.setStaticVariables(this.getStaticVariables());
        if (view.getTemplateName() == null) {
            view.setTemplateName(viewName);
        }
        if (!view.isContentTypeSet() && this.getContentType() != null) {
            view.setContentType(this.getContentType());
        }
        if (view.getLocale() == null && locale != null) {
            view.setLocale(locale);
        }
        if (view.getCharacterEncoding() == null && this.getCharacterEncoding() != null) {
            view.setCharacterEncoding(this.getCharacterEncoding());
        }
        return view;
    }
}

