/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.spring3.expression;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.expression.MapAccessor;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.ConstructorResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.OperatorOverloader;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeComparator;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.TypeLocator;
import org.springframework.expression.TypedValue;
import org.thymeleaf.spring3.expression.BeansPropertyAccessor;
import org.thymeleaf.spring3.expression.ThymeleafEvaluationContext;
import org.thymeleaf.spring3.expression.VariablesMapPropertyAccessor;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ThymeleafEvaluationContextWrapper
implements EvaluationContext {
    private final EvaluationContext delegate;
    private final List<PropertyAccessor> propertyAccessors;
    private Map<String, Object> additionalVariables;
    public static final MapAccessor MAP_ACCESSOR_INSTANCE = new MapAccessor();

    public ThymeleafEvaluationContextWrapper(EvaluationContext delegate) {
        this(delegate, null);
    }

    public ThymeleafEvaluationContextWrapper(EvaluationContext delegate, Map<String, Object> additionalVariables) {
        Validate.notNull((Object)delegate, (String)"Evaluation context delegate cannot be null");
        this.delegate = delegate;
        if (this.delegate instanceof ThymeleafEvaluationContext) {
            this.propertyAccessors = this.delegate.getPropertyAccessors();
        } else {
            this.propertyAccessors = new ArrayList<PropertyAccessor>(5);
            this.propertyAccessors.addAll(this.delegate.getPropertyAccessors());
            this.propertyAccessors.add((PropertyAccessor)VariablesMapPropertyAccessor.INSTANCE);
            this.propertyAccessors.add((PropertyAccessor)BeansPropertyAccessor.INSTANCE);
            this.propertyAccessors.add((PropertyAccessor)MAP_ACCESSOR_INSTANCE);
        }
        this.additionalVariables = additionalVariables;
    }

    public TypedValue getRootObject() {
        return this.delegate.getRootObject();
    }

    public List<ConstructorResolver> getConstructorResolvers() {
        return this.delegate.getConstructorResolvers();
    }

    public List<MethodResolver> getMethodResolvers() {
        return this.delegate.getMethodResolvers();
    }

    public List<PropertyAccessor> getPropertyAccessors() {
        return this.propertyAccessors;
    }

    public TypeLocator getTypeLocator() {
        return this.delegate.getTypeLocator();
    }

    public TypeConverter getTypeConverter() {
        return this.delegate.getTypeConverter();
    }

    public TypeComparator getTypeComparator() {
        return this.delegate.getTypeComparator();
    }

    public OperatorOverloader getOperatorOverloader() {
        return this.delegate.getOperatorOverloader();
    }

    public BeanResolver getBeanResolver() {
        return this.delegate.getBeanResolver();
    }

    public void setVariable(String name, Object value) {
        if (this.additionalVariables == null) {
            this.additionalVariables = new HashMap<String, Object>(5, 1.0f);
        }
        this.additionalVariables.put(name, value);
    }

    public Object lookupVariable(String name) {
        Object result;
        if (this.additionalVariables != null && this.additionalVariables.containsKey(name) && (result = this.additionalVariables.get(name)) != null) {
            return result;
        }
        return this.delegate.lookupVariable(name);
    }
}

