/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.testing.templateengine.testable;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.testing.templateengine.context.ITestContext;
import org.thymeleaf.testing.templateengine.context.TestContext;
import org.thymeleaf.testing.templateengine.messages.ITestMessages;
import org.thymeleaf.testing.templateengine.messages.TestMessages;
import org.thymeleaf.testing.templateengine.resource.ITestResource;
import org.thymeleaf.testing.templateengine.testable.AbstractTestable;
import org.thymeleaf.testing.templateengine.testable.ITest;
import org.thymeleaf.util.Validate;

public abstract class AbstractTest
extends AbstractTestable
implements ITest {
    public static TemplateMode DEFAULT_TEMPLATE_MODE = TemplateMode.HTML;
    public static String DEFAULT_FRAGMENT_SPEC = null;
    public static boolean DEFAULT_INPUT_CACHEABLE = true;
    private ITestContext context = new TestContext();
    private ITestMessages messages = new TestMessages();
    private TemplateMode templateMode = DEFAULT_TEMPLATE_MODE;
    private String fragmentSpec = DEFAULT_FRAGMENT_SPEC;
    private ITestResource input = null;
    private boolean inputCacheable = DEFAULT_INPUT_CACHEABLE;
    private Map<String, TemplateMode> additionalTemplateModes = new HashMap<String, TemplateMode>();
    private Map<String, ITestResource> additionalInputs = new HashMap<String, ITestResource>();

    protected AbstractTest() {
    }

    public void setContext(ITestContext context) {
        Validate.notNull((Object)context, (String)"Context cannot be null");
        this.context = context;
    }

    @Override
    public ITestContext getContext() {
        return this.context;
    }

    public void setMessages(ITestMessages messages) {
        Validate.notNull((Object)messages, (String)"Messages cannot be null");
        this.messages = messages;
    }

    @Override
    public ITestMessages getMessages() {
        return this.messages;
    }

    public void setTemplateMode(TemplateMode templateMode) {
        this.templateMode = templateMode;
    }

    @Override
    public TemplateMode getTemplateMode() {
        return this.templateMode;
    }

    @Override
    public Map<String, TemplateMode> getAdditionalTemplateModes() {
        return Collections.unmodifiableMap(this.additionalTemplateModes);
    }

    public void setAdditionalTemplateModes(Map<String, TemplateMode> additionalTemplateModes) {
        this.additionalTemplateModes = new HashMap<String, TemplateMode>(additionalTemplateModes);
    }

    public void setAdditionalTemplateMode(String name, TemplateMode templateMode) {
        this.additionalTemplateModes.put(name, templateMode);
    }

    @Override
    public boolean hasFragmentSpec() {
        return this.fragmentSpec != null;
    }

    public void setFragmentSpec(String fragmentSpec) {
        this.fragmentSpec = fragmentSpec;
    }

    @Override
    public String getFragmentSpec() {
        return this.fragmentSpec;
    }

    @Override
    public ITestResource getInput() {
        return this.input;
    }

    public void setInput(ITestResource input) {
        this.input = input;
    }

    @Override
    public Map<String, ITestResource> getAdditionalInputs() {
        return Collections.unmodifiableMap(this.additionalInputs);
    }

    public void setAdditionalInputs(Map<String, ITestResource> additionalInputs) {
        this.additionalInputs = new HashMap<String, ITestResource>(additionalInputs);
    }

    public void setAdditionalInput(String name, ITestResource resource) {
        this.additionalInputs.put(name, resource);
    }

    @Override
    public boolean isInputCacheable() {
        return this.inputCacheable;
    }

    public void setInputCacheable(boolean inputCacheale) {
        this.inputCacheable = inputCacheale;
    }
}

